# خطة اختبار النظام (Test Scenarios)

## نظرة عامة

هذا المستند يحتوي على سيناريوهات اختبار شاملة لنظام إدارة أكواد التحقق.  
يُنصح بتنفيذ هذه الاختبارات بعد كل تحديث رئيسي أو قبل نشر النظام.

---

## السيناريو 1: تفعيل سوبر موزع جديد

### الوصف
تفعيل سوبر موزع جديد باستخدام كود اشتراك SD-...

### المتطلبات السابقة
- كود SD-... صالح (تم إنشاؤه من بوت الإدارة)
- حساب تيليجرام للسوبر موزع الجديد

### الخطوات
1. أدمن يُنفذ: `/createsuperdistcode new 1,2 30 1`
2. يتم الحصول على كود مثل: `SD-ABC12345`
3. المستخدم الجديد يرسل للبوت العام: `SD-ABC12345`

### النتيجة المتوقعة
- ✅ إنشاء سجل في `super_distributors` للمستخدم
- ✅ ربط الحسابات 1,2 في `superdist_accounts` لمدة 30 يوم
- ✅ رسالة نجاح تعرض الحسابات المضافة
- ✅ يمكن للسوبر موزع استخدام `/my_accounts`

### التحقق
```sql
SELECT * FROM super_distributors WHERE telegram_id = [TG_ID];
SELECT * FROM superdist_accounts WHERE superdist_id = [SD_ID];
```

---

## السيناريو 2: توليد أكواد تفعيل

### الوصف
سوبر موزع يولّد أكواد تفعيل لحساب معين

### المتطلبات السابقة
- سوبر موزع نشط مع حساب مربوط

### الخطوات
1. سوبر موزع يُرسل: `gen_code vip-acc`
2. سوبر موزع يُرسل: `gen_codes vip-acc 5`

### النتيجة المتوقعة
- ✅ توليد كود واحد `ACT-XXXXXXXX`
- ✅ توليد 5 أكواد (تُرسل كملف إذا > 5)
- ✅ تحديث العدادات في `superdist_accounts`
- ✅ حفظ الأكواد في `activation_codes`

### التحقق
```sql
SELECT * FROM activation_codes WHERE superdist_id = [SD_ID] ORDER BY created_at DESC LIMIT 6;
SELECT activations_today FROM superdist_accounts WHERE superdist_id = [SD_ID];
```

---

## السيناريو 3: تفعيل كود من قبل زبون

### الوصف
زبون يُفعّل كود ACT-... للحصول على وصول لحساب

### المتطلبات السابقة
- كود ACT-... غير مستخدم
- الزبون مشترك في القناة

### الخطوات
1. زبون يُرسل الكود: `ACT-ABC12345`

### النتيجة المتوقعة
- ✅ تحديث حالة الكود إلى `used`
- ✅ إنشاء/تحديث سجل في `user_accounts`
- ✅ رسالة نجاح تحتوي اسم الحساب ومدة الاشتراك
- ✅ يمكن للزبون استخدام `get_code [slug]`

### التحقق
```sql
SELECT * FROM activation_codes WHERE code = 'ACT-ABC12345';
SELECT * FROM user_accounts WHERE user_id = [USER_ID];
```

---

## السيناريو 4: طلب كود تحقق (ضمن الحدود)

### الوصف
زبون يطلب كود تحقق لحساب يملكه

### المتطلبات السابقة
- زبون لديه اشتراك نشط
- لم يتجاوز الحدود

### الخطوات
1. زبون يُرسل: `get_code vip-acc`

### النتيجة المتوقعة
- ✅ توليد كود تحقق (5 أحرف)
- ✅ إرسال الكود مع رسالة "صالح لمدة 30 ثانية"
- ✅ تسجيل في `verification_logs`

### التحقق
```sql
SELECT * FROM verification_logs WHERE user_id = [USER_ID] ORDER BY requested_at DESC LIMIT 1;
```

---

## السيناريو 5: تجاوز حدود طلب الأكواد

### الوصف
زبون يحاول طلب كود بعد تجاوز الحد اليومي

### المتطلبات السابقة
- حد يومي = 2
- الزبون طلب كودين اليوم

### الخطوات
1. زبون يُرسل: `get_code vip-acc` (المرة الثالثة)

### النتيجة المتوقعة
- ❌ رفض الطلب
- ✅ رسالة خطأ: "وصلت للحد اليومي"
- ✅ تسجيل في `event_logs` نوع `limit_exceeded`

### التحقق
```sql
SELECT COUNT(*) FROM verification_logs 
WHERE user_id = [USER_ID] AND DATE(requested_at) = CURDATE();
```

---

## السيناريو 6: اشتراك lifetime

### الوصف
زبون يُفعّل كود مدى الحياة

### المتطلبات السابقة
- كود ACT-... بنوع `lifetime`

### الخطوات
1. زبون يُفعّل الكود

### النتيجة المتوقعة
- ✅ `access_type = 'lifetime'` في `user_accounts`
- ✅ `expires_at = NULL`
- ✅ يمكن للزبون طلب الأكواد دائماً

### التحقق
```sql
SELECT access_type, expires_at FROM user_accounts WHERE user_id = [USER_ID];
```

---

## السيناريو 7: اشتراك timed وانتهاؤه

### الوصف
اختبار انتهاء اشتراك مؤقت

### المتطلبات السابقة
- زبون لديه اشتراك ينتهي قريباً

### الخطوات
1. تعديل `expires_at` لتكون في الماضي (للاختبار)
2. زبون يُرسل: `get_code vip-acc`

### النتيجة المتوقعة
- ❌ رفض الطلب
- ✅ رسالة: "انتهت مدة اشتراكك"
- ✅ تحديث `status = 'expired'`

### التحقق
```sql
SELECT status, expires_at FROM user_accounts WHERE user_id = [USER_ID];
```

---

## السيناريو 8: انتهاء حساب السوبر موزع

### الوصف
تأثير انتهاء حساب سوبر موزع على الأكواد

### المتطلبات السابقة
- سوبر موزع لديه أكواد غير مستخدمة
- حسابه ينتهي

### الخطوات
1. تعديل `end_at` في `superdist_accounts` للماضي
2. تشغيل `/cron/superdist_expiry.php`

### النتيجة المتوقعة
- ✅ الأكواد غير المستخدمة → `status = 'expired'`
- ✅ سوبر موزع لا يمكنه توليد أكواد جديدة لهذا الحساب

### التحقق
```sql
SELECT status FROM activation_codes 
WHERE superdist_id = [SD_ID] AND account_id = [ACC_ID];
```

---

## السيناريو 9: البث من الإدارة

### الوصف
بث رسالة من بوت الإدارة

### الخطوات
1. أدمن يُرسل: `/broadcast_all`
2. أدمن يُرسل محتوى البث
3. أدمن يُرسل: `تأكيد`

### النتيجة المتوقعة
- ✅ إرسال الرسالة لجميع المستخدمين
- ✅ تسجيل في `broadcast_logs`
- ✅ رسالة تأكيد تعرض عدد النجاح/الفشل

### التحقق
```sql
SELECT * FROM broadcast_logs ORDER BY created_at DESC LIMIT 1;
```

---

## السيناريو 10: البث من السوبر موزع

### الوصف
سوبر موزع يبث لزبائنه

### المتطلبات السابقة
- سوبر موزع لديه `can_broadcast = 1`
- لديه زبائن

### الخطوات
1. سوبر موزع يُرسل: `/broadcast_my_users`
2. يُرسل المحتوى
3. يُرسل: `تأكيد`

### النتيجة المتوقعة
- ✅ إرسال لزبائنه فقط
- ✅ احترام `broadcast_content_type`

---

## السيناريو 11: عدم الاشتراك بالقناة

### الوصف
مستخدم غير مشترك بالقناة يحاول استخدام البوت

### الخطوات
1. مستخدم غير مشترك يُرسل: `ACT-ABC12345`
2. أو يُرسل: `get_code vip-acc`

### النتيجة المتوقعة
- ❌ رفض الطلب
- ✅ رسالة: "يجب أن تكون مشتركاً في قناتنا"
- ✅ زر/رابط للقناة

---

## السيناريو 12: حظر مستخدم

### الوصف
اختبار حظر وفك حظر

### الخطوات
1. أدمن: `/ban_user [TG_ID] سبب الحظر`
2. المستخدم يحاول أي عملية
3. أدمن: `/unban_user [TG_ID]`

### النتيجة المتوقعة
- ✅ المستخدم المحظور يتلقى رسالة حظر
- ✅ بعد فك الحظر يعود للعمل

---

## قائمة التحقق السريع

| # | السيناريو | الحالة |
|---|-----------|--------|
| 1 | تفعيل سوبر موزع جديد | ⬜ |
| 2 | توليد أكواد تفعيل | ⬜ |
| 3 | تفعيل كود من قبل زبون | ⬜ |
| 4 | طلب كود تحقق | ⬜ |
| 5 | تجاوز الحدود | ⬜ |
| 6 | اشتراك lifetime | ⬜ |
| 7 | انتهاء اشتراك timed | ⬜ |
| 8 | انتهاء حساب السوبر موزع | ⬜ |
| 9 | البث من الإدارة | ⬜ |
| 10 | البث من السوبر موزع | ⬜ |
| 11 | فحص الاشتراك بالقناة | ⬜ |
| 12 | الحظر وفك الحظر | ⬜ |

---

## ملاحظات

- يُنصح باستخدام قاعدة بيانات اختبار منفصلة
- بعض السيناريوهات تتطلب تعديل البيانات يدوياً للاختبار
- تأكد من تفعيل الـ Logging أثناء الاختبار
