# 📋 توثيق أوامر بوت الإدارة (Admin Bot Commands)

> **إصدار التوثيق:** 2.0  
> **تاريخ التحديث:** 2024-12-03

---

## 📑 الفهرس

1. [أوامر عامة](#أوامر-عامة)
2. [إدارة الحسابات](#إدارة-الحسابات)
3. [إدارة السوبر موزعين](#إدارة-السوبر-موزعين)
4. [إدارة الحدود](#إدارة-الحدود)
5. [إدارة اشتراكات الزبائن](#إدارة-اشتراكات-الزبائن)
6. [إدارة الردود](#إدارة-الردود)
7. [الحظر](#الحظر)
8. [التقارير](#التقارير)
9. [البث](#البث)
10. [نظام القسائم (جديد)](#نظام-القسائم)
11. [فحص النظام (جديد)](#فحص-النظام)
12. [القائمة السوداء للبث (جديد)](#القائمة-السوداء-للبث)
13. [إعدادات البث (جديد)](#إعدادات-البث)

---

## أوامر عامة

### `/start`
- **الهدف:** بدء التفاعل مع البوت
- **الصيغة:** `/start`
- **مثال:** `/start`
- **النتيجة المتوقعة:** رسالة ترحيب مع إرشادات أولية
- **ملاحظات:** متاح للمسؤولين فقط

### `/help [section]`
- **الهدف:** عرض قائمة الأوامر المتاحة
- **الصيغة:** `/help [accounts|superdists|limits|users|replies|bans|reports|broadcast]`
- **مثال:** `/help accounts`
- **النتيجة المتوقعة:** قائمة مفصلة بأوامر القسم المحدد
- **ملاحظات:** بدون معامل يعرض القائمة الرئيسية

### `/cancel`
- **الهدف:** إلغاء العملية الحالية
- **الصيغة:** `/cancel`
- **مثال:** `/cancel`
- **النتيجة المتوقعة:** إلغاء أي حالة انتظار وتنظيف الـ state
- **ملاحظات:** يعمل في أي وقت أثناء عملية متعددة الخطوات

---

## إدارة الحسابات

### `/addaccount`
- **الهدف:** إضافة حساب جديد
- **الصيغة:** `/addaccount slug | name | secret_key`
- **مثال:** `/addaccount vip-acc | حساب VIP | abc123secret`
- **النتيجة المتوقعة:** 
  ```
  ✅ تم إنشاء الحساب بنجاح
  🆔 المعرف: 5
  📛 الاسم: حساب VIP
  🔗 Slug: vip-acc
  ```
- **ملاحظات:** 
  - `slug` يجب أن يكون فريداً وبأحرف إنجليزية صغيرة وأرقام وشرطات فقط
  - `secret_key` اختياري، سيُولّد تلقائياً إذا لم يُحدد

### `/addaccounts_batch [--preview]`
- **الهدف:** إضافة عدة حسابات دفعة واحدة
- **الصيغة:** `/addaccounts_batch [--preview]`
- **مثال:** 
  ```
  /addaccounts_batch --preview
  ```
  ثم إرسال:
  ```
  name,slug,access_type,access_days
  حساب 1,account-1,lifetime,
  حساب 2,account-2,timed,30
  ```
- **النتيجة المتوقعة:**
  ```
  ✅ نتيجة الإدراج
  ✅ نجاح: 2
  ❌ فشل: 0
  
  📦 الحسابات المُنشأة:
  • account-1
  • account-2
  ```
- **ملاحظات:**
  - `--preview` يعرض ما سيتم إدراجه بدون تنفيذ فعلي
  - يدعم تنسيق CSV أو JSON
  - يستخدم fail-fast: أي خطأ يلغي كل العملية

### `/editaccount`
- **الهدف:** تعديل بيانات حساب
- **الصيغة:** `/editaccount [id|slug] name=... slug=...`
- **مثال:** `/editaccount vip-acc name=حساب VIP الجديد`
- **النتيجة المتوقعة:** تأكيد التعديل مع البيانات المحدثة
- **ملاحظات:** يمكن تعديل الاسم والـ slug فقط

### `/deleteaccount`
- **الهدف:** حذف حساب
- **الصيغة:** `/deleteaccount [id|slug] confirm`
- **مثال:** `/deleteaccount test-acc confirm`
- **النتيجة المتوقعة:** تأكيد الحذف أو رسالة خطأ إذا كان هناك بيانات مرتبطة
- **ملاحظات:** 
  - ⚠️ لا يمكن حذف حساب مرتبط بموزعين أو أكواد
  - كلمة `confirm` مطلوبة للتأكيد

### `/listaccounts`
- **الهدف:** عرض قائمة الحسابات
- **الصيغة:** `/listaccounts`
- **مثال:** `/listaccounts`
- **النتيجة المتوقعة:** قائمة بجميع الحسابات مع معلومات موجزة

### `/accountinfo`
- **الهدف:** عرض تفاصيل حساب
- **الصيغة:** `/accountinfo [id|slug]`
- **مثال:** `/accountinfo vip-acc`
- **النتيجة المتوقعة:** معلومات تفصيلية عن الحساب

### `/setaccountkey`
- **الهدف:** تغيير المفتاح السري للحساب
- **الصيغة:** `/setaccountkey [id] [secret_key]`
- **مثال:** `/setaccountkey 5 newsecretkey123`
- **النتيجة المتوقعة:** تأكيد تغيير المفتاح
- **ملاحظات:** ⚠️ تغيير المفتاح سيجعل الأكواد القديمة غير صالحة

### `/setaccountlimits`
- **الهدف:** تعيين حدود الحساب (تنطبق على جميع مستخدميه)
- **الصيغة:** `/setaccountlimits [id|slug] daily=X weekly=Y monthly=Z`
- **مثال:** `/setaccountlimits vip-acc daily=5 weekly=30 monthly=100`
- **النتيجة المتوقعة:** تأكيد تعيين الحدود
- **ملاحظات:** أولوية هذه الحدود 3.5 (بين السوبر موزع والعام)

---

## إدارة السوبر موزعين

### `/addsuperdist`
- **الهدف:** إضافة سوبر موزع جديد
- **الصيغة:** `/addsuperdist telegram_id | display_name`
- **مثال:** `/addsuperdist 123456789 | أحمد الموزع`
- **النتيجة المتوقعة:** تأكيد إنشاء الموزع مع معرفه

### `/listsuperdists [status]`
- **الهدف:** عرض قائمة السوبر موزعين
- **الصيغة:** `/listsuperdists [active|suspended|banned|archived]`
- **مثال:** `/listsuperdists active`
- **النتيجة المتوقعة:** قائمة الموزعين حسب الحالة

### `/superdistinfo`
- **الهدف:** عرض تفاصيل سوبر موزع
- **الصيغة:** `/superdistinfo [id]`
- **مثال:** `/superdistinfo 5`
- **النتيجة المتوقعة:** معلومات تفصيلية عن الموزع وحساباته وحدوده

### `/setsuperdistaccounts`
- **الهدف:** إضافة/إزالة حسابات للموزع
- **الصيغة:** `/setsuperdistaccounts [sd_id] add [account_ids]`
- **مثال:** `/setsuperdistaccounts 5 add 1,2,3`
- **النتيجة المتوقعة:** تأكيد إضافة الحسابات

### `/setsuperdistaccountperiod`
- **الهدف:** تعيين فترة صلاحية لحساب موزع
- **الصيغة:** `/setsuperdistaccountperiod [sd_id] [account_id] [days]`
- **مثال:** `/setsuperdistaccountperiod 5 1 30`
- **النتيجة المتوقعة:** تأكيد تمديد الصلاحية

### `/suspendsuperdist`
- **الهدف:** إيقاف موزع مؤقتاً
- **الصيغة:** `/suspendsuperdist [id]`
- **مثال:** `/suspendsuperdist 5`
- **النتيجة المتوقعة:** تأكيد الإيقاف

### `/activatesuperdist`
- **الهدف:** تفعيل موزع موقوف
- **الصيغة:** `/activatesuperdist [id]`
- **مثال:** `/activatesuperdist 5`
- **النتيجة المتوقعة:** تأكيد التفعيل

### `/archivesuperdist`
- **الهدف:** أرشفة موزع نهائياً
- **الصيغة:** `/archivesuperdist [id] [reason?]`
- **مثال:** `/archivesuperdist 5 انتهاء التعاقد`
- **النتيجة المتوقعة:** تأكيد الأرشفة
- **ملاحظات:** ⚠️ الأرشفة لا يمكن التراجع عنها

### `/createsuperdistcode`
- **الهدف:** إنشاء كود اشتراك لموزع
- **الصيغة:** `/createsuperdistcode [type] [accounts] [days] [uses]`
- **مثال:** `/createsuperdistcode new 1,2 30 1`
- **النتيجة المتوقعة:** كود الاشتراك المُولّد

### `/setsuperdistbroadcast`
- **الهدف:** تعيين صلاحيات البث للموزع
- **الصيغة:** `/setsuperdistbroadcast [id] [on|off] [content_types]`
- **مثال:** `/setsuperdistbroadcast 5 on text,stickers,photos`
- **النتيجة المتوقعة:**
  ```
  ✅ تم تحديث صلاحيات البث للسوبر موزع 5:
  • البث: ✅ مسموح
  • الأنواع المسموحة: text, stickers, photos
  ```
- **ملاحظات:**
  - الأنواع المتاحة: `text`, `stickers`, `photos`, `videos`, `documents`, `audio`
  - `off` يمنع البث تماماً بغض النظر عن الأنواع

---

## إدارة الحدود

### `/setgloballimits`
- **الهدف:** تعيين الحدود العامة (أقل أولوية)
- **الصيغة:** `/setgloballimits daily=X weekly=Y monthly=Z`
- **مثال:** `/setgloballimits daily=10 weekly=50 monthly=200`
- **النتيجة المتوقعة:** تأكيد تعيين الحدود

### `/setsuperdistlimits`
- **الهدف:** تعيين حدود موزع (أولوية 3)
- **الصيغة:** `/setsuperdistlimits [sd_id] daily=X weekly=Y monthly=Z`
- **مثال:** `/setsuperdistlimits 5 daily=20`
- **النتيجة المتوقعة:** تأكيد تعيين الحدود

### `/setuserlimits`
- **الهدف:** تعيين حدود مستخدم (أولوية 2)
- **الصيغة:** `/setuserlimits [telegram_id] daily=X weekly=Y monthly=Z`
- **مثال:** `/setuserlimits 123456789 daily=5`
- **النتيجة المتوقعة:** تأكيد تعيين الحدود

### `/setuseraccountlimits`
- **الهدف:** تعيين حدود مستخدم لحساب معين (أعلى أولوية)
- **الصيغة:** `/setuseraccountlimits [telegram_id] [slug] daily=X weekly=Y monthly=Z`
- **مثال:** `/setuseraccountlimits 123456789 vip-acc daily=3`
- **النتيجة المتوقعة:** تأكيد تعيين الحدود

---

## نظام القسائم

### `/create_voucher`
- **الهدف:** إنشاء قسيمة جديدة
- **الصيغة:** 
  - للموزعين: `/create_voucher sd [account_ids] [days] [max_uses?]`
  - لحزم الأكواد: `/create_voucher bundle [account_id] [codes_count] [type?] [days?]`
- **مثال 1:** `/create_voucher sd 1,2,3 30 1`
- **مثال 2:** `/create_voucher bundle 1 10 timed 30`
- **النتيجة المتوقعة:**
  ```
  ✅ تم إنشاء القسيمة بنجاح!
  🎟️ الكود: VCH-A1B2-C3D4
  🆔 المعرف: 15
  📋 النوع: sd
  ```
- **ملاحظات:**
  - `sd` = قسيمة اشتراك موزع (تضيف حسابات للموزع)
  - `bundle` = حزمة أكواد تفعيل (تولد أكواد ACT-)

### `/voucher_info`
- **الهدف:** عرض معلومات قسيمة
- **الصيغة:** `/voucher_info [code]`
- **مثال:** `/voucher_info VCH-A1B2-C3D4`
- **النتيجة المتوقعة:** معلومات تفصيلية عن القسيمة

### `/list_vouchers [type] [status]`
- **الهدف:** عرض قائمة القسائم
- **الصيغة:** `/list_vouchers [sd|activation_bundle] [unused|partial|used|expired|disabled]`
- **مثال:** `/list_vouchers sd unused`
- **النتيجة المتوقعة:** قائمة القسائم المطابقة

### `/disable_voucher`
- **الهدف:** تعطيل قسيمة
- **الصيغة:** `/disable_voucher [code]`
- **مثال:** `/disable_voucher VCH-A1B2-C3D4`
- **النتيجة المتوقعة:** تأكيد التعطيل

---

## فحص النظام

### `/run_system_check [type]`
- **الهدف:** تشغيل فحص شامل للنظام
- **الصيغة:** `/run_system_check [full|quick]`
- **مثال:** `/run_system_check full`
- **النتيجة المتوقعة:**
  ```
  📊 تقرير فحص النظام
  
  ✅ جميع الاختبارات نجحت
  
  📊 الإحصائيات:
  - إجمالي: 10
  - ناجح: 10
  - فاشل: 0
  - تحذيرات: 1
  
  ⏱️ المدة: 245ms
  
  📁 التقرير محفوظ في:
  reports/system_checks/2024-12-03_12-30-45.txt
  ```
- **ملاحظات:**
  - `full` = فحص شامل (10+ اختبارات)
  - `quick` = فحص سريع (3 اختبارات أساسية)

### `/system_reports [limit]`
- **الهدف:** عرض قائمة تقارير الفحص السابقة
- **الصيغة:** `/system_reports [limit?]`
- **مثال:** `/system_reports 5`
- **النتيجة المتوقعة:** قائمة بآخر التقارير

### `/view_report [id]`
- **الهدف:** عرض تقرير فحص محدد
- **الصيغة:** `/view_report [id]`
- **مثال:** `/view_report 15`
- **النتيجة المتوقعة:** تفاصيل التقرير

---

## القائمة السوداء للبث

### `/blacklist_add`
- **الهدف:** إضافة كلمة للقائمة السوداء
- **الصيغة:** `/blacklist_add [word] [type?] [severity?]`
- **مثال:** `/blacklist_add spam word block`
- **النتيجة المتوقعة:** تأكيد الإضافة
- **ملاحظات:**
  - **الأنواع:** `word` (كلمة), `regex` (تعبير نمطي), `domain` (نطاق)
  - **الخطورة:** `block` (حظر), `warn` (تحذير), `log` (تسجيل فقط)

### `/blacklist_remove [id]`
- **الهدف:** حذف عنصر من القائمة السوداء
- **الصيغة:** `/blacklist_remove [id]`
- **مثال:** `/blacklist_remove 5`
- **النتيجة المتوقعة:** تأكيد الحذف

### `/blacklist_list`
- **الهدف:** عرض القائمة السوداء
- **الصيغة:** `/blacklist_list`
- **مثال:** `/blacklist_list`
- **النتيجة المتوقعة:** قائمة بجميع الكلمات المحظورة

---

## إعدادات البث

### `/broadcast_settings`
- **الهدف:** عرض إعدادات البث الحالية
- **الصيغة:** `/broadcast_settings`
- **مثال:** `/broadcast_settings`
- **النتيجة المتوقعة:**
  ```
  ⚙️ إعدادات البث
  
  • chunk_size = 30
  • delay_between_chunks_ms = 1000
  • delay_between_messages_ms = 50
  • max_retries_on_429 = 3
  • blacklist_enabled = 1
  • moderation_enabled = 1
  ```

### `/set_broadcast_setting [key] [value]`
- **الهدف:** تعديل إعداد بث
- **الصيغة:** `/set_broadcast_setting [key] [value]`
- **مثال:** `/set_broadcast_setting chunk_size 50`
- **النتيجة المتوقعة:** تأكيد التعديل

### `/blocked_broadcasts [limit]`
- **الهدف:** عرض البثات المحظورة
- **الصيغة:** `/blocked_broadcasts [limit?]`
- **مثال:** `/blocked_broadcasts 10`
- **النتيجة المتوقعة:** قائمة بالبثات المرفوضة مع الأسباب

---

## 📊 ترتيب أولوية الحدود

```
1️⃣ user_account (الأعلى) - حدود مستخدم لحساب محدد
    ↓
2️⃣ user - حدود المستخدم العامة
    ↓
3️⃣ superdist - حدود السوبر موزع
    ↓
3.5️⃣ account - حدود الحساب
    ↓
4️⃣ global (الأدنى) - الحدود العامة
```

**ملاحظات:**
- `NULL` = لا حد مخصص (يُستخدم الحد من المستوى الأدنى)
- `0` = محظور تماماً
- `> 0` = الحد الفعلي

---

## 🔐 ملاحظات أمنية

1. جميع الأوامر متاحة للمسؤولين فقط (يتم التحقق من `ADMIN_IDS`)
2. لا تُطبع التوكنات أو المفاتيح السرية في السجلات
3. واجهات API تتطلب `X-API-Key` header
4. webhooks الدفع تتطلب التحقق من التوقيع
5. System Checker لا يغير البيانات (read-only)

---

## 📞 الدعم

للمساعدة أو الإبلاغ عن مشاكل:
- استخدم `/help` داخل البوت
- راجع سجلات الأخطاء في `logs/`
- شغّل `/run_system_check` لتشخيص المشاكل
