<?php
/**
 * ============================================================
 * ملف الحدود الافتراضية (Default Limits Configuration)
 * ============================================================
 * 
 * هذا الملف يحتوي الحدود الافتراضية للنظام.
 * هذه القيم تُستخدم فقط إذا لم تكن موجودة في قاعدة البيانات.
 * 
 * الأولوية:
 *   1. قاعدة البيانات (إذا وُجدت)
 *   2. هذا الملف (كـ fallback)
 */

return [
    // ============================================================
    // حدود طلب أكواد التحقق (Verification Limits)
    // ============================================================
    // تنطبق على جميع الزبائن ما لم يُحدد خلاف ذلك
    
    'verification' => [
        'daily'   => 2,   // الحد اليومي لكل مستخدم لكل حساب
        'weekly'  => 10,  // الحد الأسبوعي
        'monthly' => 30,  // الحد الشهري
    ],
    
    // ============================================================
    // حدود توليد أكواد التفعيل (Activation Code Generation Limits)
    // ============================================================
    // تنطبق على السوبر موزعين لكل حساب
    // NULL = بلا حد (إذا لم يُحدد في superdist_accounts)
    
    'activation_generation' => [
        'daily'   => null,  // بلا حد افتراضي
        'weekly'  => null,
        'monthly' => null,
    ],
    
    // ============================================================
    // إعدادات أخرى للحدود
    // ============================================================
    
    // الحد الأقصى لتوليد أكواد في طلب واحد (gen_codes)
    'max_codes_per_request' => 100,
    
    // مدة صلاحية كود التفعيل الافتراضية (بالأيام)
    // NULL = لا ينتهي (إلا بانتهاء صلاحية السوبر موزع على الحساب)
    'default_activation_code_validity_days' => null,
    
    // مدة صلاحية كود اشتراك السوبر موزع الافتراضية (بالأيام)
    // NULL = لا ينتهي
    'default_superdist_code_validity_days' => null,
];
