-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- مضيف: localhost:3306
-- وقت الجيل: 03 ديسمبر 2025 الساعة 17:57
-- إصدار الخادم: 11.4.8-MariaDB-cll-lve
-- نسخة PHP: 8.3.27

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- قاعدة بيانات: `upfovlxc_finaldistributorbotplus`
--

DELIMITER $$
--
-- الإجراءات
--
CREATE DEFINER=`cpses_updxvhqs5g`@`localhost` PROCEDURE `disable_superdist_codes` (IN `p_superdist_id` INT)   BEGIN
    UPDATE `activation_codes`
    SET `status` = 'disabled'
    WHERE `superdist_id` = p_superdist_id
      AND `status` = 'unused';
END$$

CREATE DEFINER=`cpses_updxvhqs5g`@`localhost` PROCEDURE `expire_outdated_codes` ()   BEGIN
    -- أكواد التفعيل التي انتهت صلاحيتها مباشرة
    UPDATE `activation_codes`
    SET `status` = 'expired'
    WHERE `status` = 'unused'
      AND `expires_at` IS NOT NULL
      AND `expires_at` < NOW();
    
    -- أكواد التفعيل لسوبر موزعين انتهت صلاحية حساباتهم
    UPDATE `activation_codes` ac
    INNER JOIN `superdist_accounts` sa ON ac.superdist_id = sa.superdist_id AND ac.account_id = sa.account_id
    SET ac.status = 'expired'
    WHERE ac.status = 'unused'
      AND sa.end_at < NOW();
    
    -- أكواد اشتراك السوبر موزعين المنتهية
    UPDATE `superdist_subscription_codes`
    SET `status` = 'expired'
    WHERE `status` IN ('unused', 'partial')
      AND `expires_at` IS NOT NULL
      AND `expires_at` < NOW();
END$$

CREATE DEFINER=`cpses_updxvhqs5g`@`localhost` PROCEDURE `get_system_stats` ()   BEGIN
    SELECT
        (SELECT COUNT(*) FROM `accounts` WHERE `status` = 'active') AS active_accounts,
        (SELECT COUNT(*) FROM `super_distributors` WHERE `status` = 'active') AS active_superdists,
        (SELECT COUNT(*) FROM `super_distributors` WHERE `status` = 'suspended') AS suspended_superdists,
        (SELECT COUNT(*) FROM `super_distributors` WHERE `status` = 'banned') AS banned_superdists,
        (SELECT COUNT(*) FROM `users` WHERE `status` = 'active') AS active_users,
        (SELECT COUNT(*) FROM `users` WHERE `status` = 'banned') AS banned_users,
        (SELECT COUNT(*) FROM `superdist_subscription_codes` WHERE `status` = 'unused') AS unused_sd_codes,
        (SELECT COUNT(*) FROM `superdist_subscription_codes` WHERE `status` = 'used') AS used_sd_codes,
        (SELECT COUNT(*) FROM `activation_codes` WHERE `status` = 'unused') AS unused_act_codes,
        (SELECT COUNT(*) FROM `activation_codes` WHERE `status` = 'used') AS used_act_codes,
        (SELECT COUNT(*) FROM `activation_codes` WHERE `status` = 'expired') AS expired_act_codes,
        (SELECT COUNT(*) FROM `verification_logs`) AS total_verifications,
        (SELECT COUNT(*) FROM `verification_logs` WHERE DATE(`requested_at`) = CURDATE()) AS today_verifications,
        (SELECT COUNT(*) FROM `verification_logs` WHERE `requested_at` >= DATE_SUB(NOW(), INTERVAL 7 DAY)) AS week_verifications,
        (SELECT COUNT(*) FROM `verification_logs` WHERE `requested_at` >= DATE_SUB(NOW(), INTERVAL 30 DAY)) AS month_verifications;
END$$

CREATE DEFINER=`cpses_updxvhqs5g`@`localhost` PROCEDURE `reset_daily_activation_counters` ()   BEGIN
    UPDATE `superdist_accounts`
    SET `activations_today` = 0,
        `last_activation_reset` = CURDATE()
    WHERE `last_activation_reset` IS NULL OR `last_activation_reset` < CURDATE();
END$$

CREATE DEFINER=`cpses_updxvhqs5g`@`localhost` PROCEDURE `reset_monthly_activation_counters` ()   BEGIN
    UPDATE `superdist_accounts`
    SET `activations_this_month` = 0;
END$$

CREATE DEFINER=`cpses_updxvhqs5g`@`localhost` PROCEDURE `reset_weekly_activation_counters` ()   BEGIN
    UPDATE `superdist_accounts`
    SET `activations_this_week` = 0;
END$$

CREATE DEFINER=`cpses_updxvhqs5g`@`localhost` PROCEDURE `sp_preview_users_access_change` (IN `p_account_ids` TEXT, IN `p_new_access_type` VARCHAR(20), IN `p_force` TINYINT(1))   BEGIN
    DECLARE v_account_list TEXT;
    
    SET v_account_list = REPLACE(REPLACE(p_account_ids, ' ', ''), ',', ',');
    
    -- عرض إحصائيات التغيير
    SELECT 
        COUNT(*) as total_affected,
        SUM(CASE WHEN ua.access_type = 'lifetime' THEN 1 ELSE 0 END) as lifetime_count,
        SUM(CASE WHEN ua.access_type = 'timed' THEN 1 ELSE 0 END) as timed_count,
        COUNT(DISTINCT ua.user_id) as unique_users,
        COUNT(DISTINCT ua.account_id) as unique_accounts
    FROM user_accounts ua
    WHERE FIND_IN_SET(ua.account_id, v_account_list) > 0
        AND (p_force = 1 OR ua.access_type != 'lifetime');
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- بنية الجدول `accounts`
--

CREATE TABLE `accounts` (
  `id` int(10) UNSIGNED NOT NULL,
  `slug` varchar(64) NOT NULL COMMENT 'معرّف نصي فريد (مثل: acc-vip-2025)',
  `name` varchar(128) NOT NULL COMMENT 'الاسم الوصفي للحساب',
  `secret_key` varchar(128) NOT NULL COMMENT 'المفتاح السري لتوليد أكواد التحقق الزمنية',
  `description` text DEFAULT NULL COMMENT 'وصف اختياري للحساب',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active' COMMENT 'حالة الحساب',
  `default_access_type` enum('lifetime','timed') NOT NULL DEFAULT 'lifetime' COMMENT 'نوع الاشتراك الافتراضي للزبائن',
  `default_access_days` int(10) UNSIGNED DEFAULT NULL COMMENT 'عدد أيام الاشتراك الافتراضي (إذا كان timed)',
  `default_inherit_global` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=يرث من الإعدادات العامة، 0=يستخدم القيم المحددة',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول الحسابات الرئيسية';

--
-- إرجاع أو استيراد بيانات الجدول `accounts`
--

INSERT INTO `accounts` (`id`, `slug`, `name`, `secret_key`, `description`, `status`, `default_access_type`, `default_access_days`, `default_inherit_global`, `created_at`, `updated_at`) VALUES
(7, 'greatpackagebot1', 'greatpackagebot1', 'UiqwIKc1r3i8EBFaElesiJqyWRY=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(8, 'greatpackagebot2', 'greatpackagebot2', 'eUb0cA7fDEGWCzJDIvrc5P7O1ec=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(9, 'kerolos-2007', 'kerolos_2007', 'SzgFSy32QsRcP+nEgIdl8bcuGVA=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(10, 'greatpackagebot4', 'greatpackagebot4', 'ulMq9gxJx1a7XX/pFNL49ljXeR4=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(11, 'greatpackagebot6', 'greatpackagebot6', 'PBVMqP0bpRurNFGzzijCh3H176Q=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(12, 'greatpackagebot7', 'greatpackagebot7', 'n0A85BPNy7yzr48qUS6X41Oiu2U=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(13, 'pouriyaardani3', 'pouriyaardani3', 'gWeogDschfY1d4g6OTotiQCTL2E=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(14, 'greatpackagebot20', 'greatpackagebot20', 'Xb2g0nZqRCJEL88hvvaiLvIkvaA=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(15, '1281400826', '1281400826', 'QpHRyUnKrpLWNrNGZx7SAODZsOY=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(16, 'greatpackagebot18', 'greatpackagebot18', 'S7P2j81eaim5kOp4Y5PoxwUgZi8=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(17, 'greatpackagebot17', 'greatpackagebot17', 'aX1ouMDYJPqKqX9oNXs66yyZT2E=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(18, 'yousefabufarah1', 'yousefabufarah1', 'KYMv2tZRswlTQy7IE5+aQM8qdOM=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(19, 'ricardomax299', 'ricardomax299', 'LTQuZ0A97EZPqOgAWEcctwDpkxw=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(20, 'iicharisma', 'iicharisma', 'OD/hxDd4/dOkhcRtZRxXm0kxEgs=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(21, 'greatpackagebot13', 'greatpackagebot13', 'QtFFXFgKldol2wdO78WRXCz4SOA=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(22, 'xpkillergg', 'xpkillergg', 'LLrIecUFnL3oMTxAkd/3yAu821A=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(23, 'greatpackagebot12', 'greatpackagebot12', 'Fc2N2itIP2YjGuY16+6rjxsJlpg=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(24, 'greatpackagebot10', 'greatpackagebot10', '2gYvD07G3ntuxoZhWlnvlnpxaw0=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(25, 'greatpackagebot9', 'greatpackagebot9', 'fONiVjytWxx268Ce7uFqwVGkNXc=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(26, 'greatpackagebot8', 'greatpackagebot8', 'xgr8j484nR0ZK47c3WmgVLxe9e0=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(27, 'yulefilgueira', 'yulefilgueira', 'bvh0IBNtpZslzXXGadX8z8+JVgw=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(28, 'kaire009', 'kaire009', 'Q7r7ZPtrSy8a4Cz3YpiPYCKI0jE=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(29, 'dandy-lie', 'dandy_lie', 'rLXxDkIuwIHrCuRn0oAF195mes8=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(30, 'haloxx15', 'haloxx15', '+lZhatr2/VEqEeaUZyufqZdWbg8=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(31, 'okagawaguilherme', 'okagawaguilherme', 'otM+NQJcWN7VXRNgE+zPAKyEUvE=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(32, 'loairuoi', 'loairuoi', 'gaE3vgU5wJ+1iXmXWxHVJayzaJs=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(33, 'wolyas1', 'wolyas1', 'agvci414ydrHnd/sIyD9O6hQhy0=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(34, 's4d-warrior', 's4d_warrior', '9sFwK56+qilFWFQtVBglW63MOQA=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(35, '1741498889', '1741498889', 'ZWJlcr3Z121ZbLfEWQbh8ZwM5SE=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:55:12', '2025-12-03 22:55:12'),
(36, 'thelan164', 'thelan164', 'v3RTD9IhLfBLDzolbwq4tncCI0M=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(37, 'mrcuriousty', 'mrcuriousty', 'lrxzWsxjOUNPm+t5IZ+Wrg+dRjc=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(38, 'augustrox15', 'augustrox15', 'WYFSjJm0uMa5IiF+ObdQ1Em/+vQ=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(39, 'greatpackage718', 'greatpackage718', '/vfl5mmenmFGjBl3iNGfMxx6LEU=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(40, 'hxush315h', 'hxush315h', 'n0tObl7/4zy91Wddvn/SU4JwMUY=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(41, 'djud2548', 'djud2548', 'qPIOkPE6ORnkS9jBCf/qYbWuhA4=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(42, 'ppae3548', 'ppae3548', 'SFyB+GNYqB4HFFAJjFnlf8jGj7Q=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(43, 'kopliperv', 'kopliperv', 'R8NbUfbdCbFv2235A6JoVxvy6FY=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(44, 'hsujsi777', 'hsujsi777', 'JlN6xKs3D9bGEuFTuua/k4i1F7U=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(45, 'azilo19', 'azilo19', 'rwGF/g+X7jzwadkb6C4LtwlvY8Y=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(46, 'hshsh772', 'hshsh772', 'L9S90qbNpYEVCj0BVG5EEpLPBRM=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(47, 'cuentasteam1974', 'cuentasteam1974', 'jVJhouyvfLNnRr5V5PHb4Fo9010=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(48, 'packageiq08', 'packageiq08', 'QVreUYXxSGFIzFsmdIl5XsdvJ9Y=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(49, 'spottypsychedelicmonkey', 'spottypsychedelicmonkey', 'l2O2jsV1Bv6xq4wNlUuo7AG4+t0=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(50, 'certainlivingzebra', 'certainlivingzebra', 'swxrwckWTw8hJBR3VO9k7r1Q8Ow=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(51, 'onelamequelea', 'onelamequelea', 'HFj1/inud97M0N3xaoWA82mzWUw=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(52, 'electricstereotypedgoat', 'electricstereotypedgoat', 'cEWefFuY6auYAFM+CZ+/YzHiSPA=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(53, 'funnyrattycoyote', 'funnyrattycoyote', '/5L6fgqXW+ME4T6jQtzuVXpYcYw=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(54, 'tenderthickrat', 'tenderthickrat', 'CPcA2AvSlcP3luqW2b/frFv2nzY=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(55, 'crazyhellishreindeer', 'crazyhellishreindeer', 't25LXMlOVVSoGf4VaHL1e1C+vBE=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(56, 'pastoralshakyherring', 'pastoralshakyherring', 'u+z5t3U8KWHN6OtXj1L95xC8zgM=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(57, 'wastefulstupidlapwing', 'wastefulstupidlapwing', 'gnTFCOA0CWfMVOkarF1PoeouVZI=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(58, 'lackinghulkingbear', 'lackinghulkingbear', 'RBPiD9/5hMGBxoX7vYMv/xOlmi8=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(59, 'famousbefittingboar', 'famousbefittingboar', 'PtzcAWCQ/vFMgfjwWxMrjb0ldJI=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(60, 'gooddullbat', 'gooddullbat', 'gxuc4BdD3GJAhInKjJBwdabL41c=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(61, 'greatpackage1', 'greatpackage1', 'QvejS/EjScYcegOB0P8aSjZBubk=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(62, 'greatpackage2', 'greatpackage2', 'DGv88u74LMcP7ToERmWBEnLzWtA=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(63, 'greatpackage54', 'greatpackage54', 'Wwk7P/Ed+1vBGY9adWTV0il7IK0=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(64, 'lpbyu85599', 'lpbyu85599', 'eYZfP/Gd3pf/eGZWokPPEr4Ppg=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(65, 'greatpackagebot138', 'greatpackagebot138', 'qL6DjnsNg4tqedgUcF/57CmMUOU=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:56:23', '2025-12-03 22:56:23'),
(66, 'greatpackagebot15pes', 'greatpackagebot15pes', 'g6tBDdNsNs2SUBCqIpm98u8xxxY=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(67, 'greatiq3', 'greatiq3', 'pBlmx2tI9GNxpY6IWe0bY90ytUU=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(68, 'greatiq6', 'greatiq6', 'y2NHSX2aFvrLPvurjoMLNLW/iLg=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(69, 'greatiq8', 'greatiq8', 'ErKHvt/U/vhQ9Uk7GM+HRObVAbU=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(70, 'greatiq9', 'greatiq9', 'aKIG616bR3mPluqRLOwB3mbaEyk=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(71, 'greatiq10', 'greatiq10', 'sVoMul1siYhfePSCevaCvOvVdmc=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(72, 'greatiq11', 'greatiq11', 'u6b+hliexGWMZrG5rsMh+UTmBzA=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(73, 'greatiq12', 'greatiq12', 'fmtNO/ESzKpBBHpqAXFz1O+lv/s=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(74, 'greatiq13', 'greatiq13', 'Ds7sxdush9dAk1PZvnQpbeS5S6Y=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(75, 'greatiq14', 'greatiq14', '+MjX8G/2s7mjAAENc0BvdtbCbPk=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(76, 'greatiq15', 'greatiq15', 'L+mD20MHQf3MpBpQcylqxVX2KTE=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(77, 'greatiq16', 'greatiq16', 'nb/VxAaQPqKQesjINanXlzhAOjQ=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(78, 'greatiq7', 'greatiq7', 'u1Iv94Y4kaz1Pg4oDciHCRLlqY0=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(79, 'cyberend007', 'cyberend007', 'Fu5+7raSXs8x65DTBAnjPyRasMI=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(80, 'sherff6', 'sherff6', 'Eys+8MvDXVOEi3wvtsdoxqjA8j0=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(81, 'tamiess', 'tamiess', '+BHuDICQ3TXHzB3pTdScqJGt0fU=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(82, 'igorfalcao1984', 'igorfalcao1984', '16cYtXAFIt2Y6sR5L/Bk83OBi2A=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(83, 'laitjuuuuuuuuu', 'laitjuuuuuuuuu', 'sY4TuZM97oh1HV9txNz3548+2Jo=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(84, 'greatbot11', 'greatbot11', 'ItVil4wz5nvoeyBzeBC6pXM6r5E=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(85, 'rangda27', 'rangda27', 'X1CcqpQEm0K/k3CNyUQcbG6FbI0=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(86, 'greatbotragnarok', 'greatbotragnarok', 'IbOxtNxxP6lhwh1Sgs6crvh9RNE=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(87, 'greatbottekken8', 'greatbottekken8', 'TFhF84bYrRG9x1yWJuSTcekmO9Y=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(88, 'greatpackagesekiro', 'greatpackagesekiro', 'AExS38DePD4lW/I/Y9UNN73TuBw=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(89, 'greatpackage400', 'greatpackage400', 'inRZgIhJzoYUZDv4NBg7H/tn1tM=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(90, 'greatbot92', 'greatbot92', '7qUW4gAfxgbrad7OCh3BA02MbnU=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(91, 'greatpackage86', 'greatpackage86', 'MsfPZyp46esMoFBxUAqF0e2D33E=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(92, 'greatbotsilent', 'greatbotsilent', 'I09kj08p7ilGJzmjLt4Zp8aFRwc=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(93, 'greatbot27', 'greatbot27', 'Dz5W/m8TAmMVGK1AvIAU7kjvORU=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(94, 'greatbotdyinglight', 'greatbotdyinglight', 'Uxy9W5nVI3SwY2y9LN55AwYy/o8=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01'),
(95, 'greatbothellisus', 'greatbothellisus', 'S0TNeJqSEnb//oXkhhWcO31wPzo=', NULL, 'active', 'timed', 30, 1, '2025-12-03 22:57:01', '2025-12-03 22:57:01');

--
-- القوادح `accounts`
--
DELIMITER $$
CREATE TRIGGER `trg_accounts_audit` AFTER UPDATE ON `accounts` FOR EACH ROW BEGIN
    IF OLD.default_access_type != NEW.default_access_type 
       OR OLD.default_access_days != NEW.default_access_days 
       OR OLD.default_inherit_global != NEW.default_inherit_global THEN
        
        INSERT INTO admin_audit (
            admin_id, 
            admin_telegram_id, 
            action, 
            target_type, 
            target_ids,
            old_values,
            new_values,
            affected_count
        ) VALUES (
            0, -- سيتم تحديثه من الكود
            0,
            'account_default_changed',
            'accounts',
            JSON_ARRAY(NEW.id),
            JSON_OBJECT(
                'access_type', OLD.default_access_type,
                'access_days', OLD.default_access_days,
                'inherit_global', OLD.default_inherit_global
            ),
            JSON_OBJECT(
                'access_type', NEW.default_access_type,
                'access_days', NEW.default_access_days,
                'inherit_global', NEW.default_inherit_global
            ),
            1
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- بنية الجدول `activation_codes`
--

CREATE TABLE `activation_codes` (
  `id` int(10) UNSIGNED NOT NULL,
  `code` varchar(32) NOT NULL COMMENT 'الكود الفريد (مثل: ACT-ABCD-1234)',
  `superdist_id` int(10) UNSIGNED NOT NULL COMMENT 'السوبر موزع الذي ولّد الكود',
  `account_id` int(10) UNSIGNED NOT NULL COMMENT 'الحساب المرتبط بالكود',
  `access_type` enum('lifetime','timed') NOT NULL DEFAULT 'lifetime' COMMENT 'نوع الاشتراك',
  `access_days` int(10) UNSIGNED DEFAULT NULL COMMENT 'عدد أيام الاشتراك (إذا كان timed)',
  `expires_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ انتهاء صلاحية الكود (يمكن أن يكون قبل انتهاء صلاحية السوبر موزع)',
  `status` enum('unused','used','expired','disabled') NOT NULL DEFAULT 'unused' COMMENT 'حالة الكود',
  `used_by_user_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'المستخدم الذي فعّل الكود',
  `used_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ التفعيل',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='أكواد التفعيل للزبائن';

-- --------------------------------------------------------

--
-- بنية الجدول `admin_audit`
--

CREATE TABLE `admin_audit` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `admin_id` bigint(20) UNSIGNED NOT NULL COMMENT 'معرف المدير الذي قام بالعملية',
  `admin_telegram_id` bigint(20) NOT NULL COMMENT 'Telegram ID للمدير',
  `action` varchar(100) NOT NULL COMMENT 'نوع العملية (set_users_access, set_default_account_access, etc)',
  `target_type` varchar(50) NOT NULL COMMENT 'نوع الهدف (accounts, users, settings)',
  `target_ids` text DEFAULT NULL COMMENT 'معرفات الأهداف المتأثرة (JSON array)',
  `old_values` text DEFAULT NULL COMMENT 'القيم القديمة قبل التغيير (JSON)',
  `new_values` text DEFAULT NULL COMMENT 'القيم الجديدة بعد التغيير (JSON)',
  `affected_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'عدد السجلات المتأثرة',
  `is_preview` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1=معاينة فقط، 0=تنفيذ فعلي',
  `flags` varchar(255) DEFAULT NULL COMMENT 'flags مستخدمة (force, notify, etc)',
  `status` enum('success','partial','failed') NOT NULL DEFAULT 'success',
  `error_message` text DEFAULT NULL COMMENT 'رسالة الخطأ إن وجدت',
  `execution_time_ms` int(10) UNSIGNED DEFAULT NULL COMMENT 'وقت التنفيذ بالميلي ثانية',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجل تدقيق العمليات الإدارية';

--
-- إرجاع أو استيراد بيانات الجدول `admin_audit`
--

INSERT INTO `admin_audit` (`id`, `admin_id`, `admin_telegram_id`, `action`, `target_type`, `target_ids`, `old_values`, `new_values`, `affected_count`, `is_preview`, `flags`, `status`, `error_message`, `execution_time_ms`, `created_at`) VALUES
(1, 0, 0, 'account_default_changed', 'accounts', '[1]', '{\"access_type\": \"lifetime\", \"access_days\": null, \"inherit_global\": 1}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(2, 0, 475567305, 'set_default_account_access', 'accounts', '[1]', '{\"default_access_type\":\"lifetime\",\"default_access_days\":null,\"default_inherit_global\":\"1\"}', '{\"default_inherit_global\":0,\"default_access_type\":\"timed\",\"default_access_days\":30}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(3, 0, 0, 'account_default_changed', 'accounts', '[2]', '{\"access_type\": \"lifetime\", \"access_days\": null, \"inherit_global\": 1}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(4, 0, 475567305, 'set_default_account_access', 'accounts', '[2]', '{\"default_access_type\":\"lifetime\",\"default_access_days\":null,\"default_inherit_global\":\"1\"}', '{\"default_inherit_global\":0,\"default_access_type\":\"timed\",\"default_access_days\":30}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(5, 0, 0, 'account_default_changed', 'accounts', '[3]', '{\"access_type\": \"lifetime\", \"access_days\": null, \"inherit_global\": 1}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(6, 0, 475567305, 'set_default_account_access', 'accounts', '[3]', '{\"default_access_type\":\"lifetime\",\"default_access_days\":null,\"default_inherit_global\":\"1\"}', '{\"default_inherit_global\":0,\"default_access_type\":\"timed\",\"default_access_days\":30}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(7, 0, 0, 'account_default_changed', 'accounts', '[4]', '{\"access_type\": \"timed\", \"access_days\": 20, \"inherit_global\": 1}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(8, 0, 475567305, 'set_default_account_access', 'accounts', '[4]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"20\",\"default_inherit_global\":\"1\"}', '{\"default_inherit_global\":0,\"default_access_type\":\"timed\",\"default_access_days\":30}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(9, 0, 0, 'account_default_changed', 'accounts', '[5]', '{\"access_type\": \"timed\", \"access_days\": 20, \"inherit_global\": 1}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(10, 0, 475567305, 'set_default_account_access', 'accounts', '[5]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"20\",\"default_inherit_global\":\"1\"}', '{\"default_inherit_global\":0,\"default_access_type\":\"timed\",\"default_access_days\":30}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(11, 0, 0, 'account_default_changed', 'accounts', '[6]', '{\"access_type\": \"timed\", \"access_days\": 20, \"inherit_global\": 1}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(12, 0, 475567305, 'set_default_account_access', 'accounts', '[6]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"20\",\"default_inherit_global\":\"1\"}', '{\"default_inherit_global\":0,\"default_access_type\":\"timed\",\"default_access_days\":30}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:08:44'),
(13, 0, 0, 'account_default_changed', 'accounts', '[1]', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(14, 0, 475567305, 'set_default_account_access', 'accounts', '[1]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"30\",\"default_inherit_global\":\"0\"}', '{\"default_inherit_global\":1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(15, 0, 0, 'account_default_changed', 'accounts', '[2]', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(16, 0, 475567305, 'set_default_account_access', 'accounts', '[2]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"30\",\"default_inherit_global\":\"0\"}', '{\"default_inherit_global\":1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(17, 0, 0, 'account_default_changed', 'accounts', '[3]', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(18, 0, 475567305, 'set_default_account_access', 'accounts', '[3]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"30\",\"default_inherit_global\":\"0\"}', '{\"default_inherit_global\":1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(19, 0, 0, 'account_default_changed', 'accounts', '[4]', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(20, 0, 475567305, 'set_default_account_access', 'accounts', '[4]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"30\",\"default_inherit_global\":\"0\"}', '{\"default_inherit_global\":1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(21, 0, 0, 'account_default_changed', 'accounts', '[5]', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(22, 0, 475567305, 'set_default_account_access', 'accounts', '[5]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"30\",\"default_inherit_global\":\"0\"}', '{\"default_inherit_global\":1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(23, 0, 0, 'account_default_changed', 'accounts', '[6]', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 0}', '{\"access_type\": \"timed\", \"access_days\": 30, \"inherit_global\": 1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21'),
(24, 0, 475567305, 'set_default_account_access', 'accounts', '[6]', '{\"default_access_type\":\"timed\",\"default_access_days\":\"30\",\"default_inherit_global\":\"0\"}', '{\"default_inherit_global\":1}', 1, 0, NULL, 'success', NULL, NULL, '2025-12-03 22:09:21');

-- --------------------------------------------------------

--
-- بنية الجدول `bans`
--

CREATE TABLE `bans` (
  `id` int(10) UNSIGNED NOT NULL,
  `target_type` enum('user','superdist') NOT NULL COMMENT 'نوع المحظور',
  `target_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف المحظور في جدوله',
  `target_telegram_id` bigint(20) NOT NULL COMMENT 'معرف تيليجرام للمحظور',
  `reason` varchar(255) DEFAULT NULL COMMENT 'سبب الحظر',
  `banned_by` varchar(64) NOT NULL DEFAULT 'admin' COMMENT 'من قام بالحظر (admin أو superdist_123)',
  `banned_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'تاريخ الحظر',
  `unbanned_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ فك الحظر (إن وجد)',
  `unbanned_by` varchar(64) DEFAULT NULL COMMENT 'من فك الحظر',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'هل الحظر فعّال (للسجل التاريخي)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجل الحظر (للتاريخ والتفاصيل)';

-- --------------------------------------------------------

--
-- بنية الجدول `batch_operations`
--

CREATE TABLE `batch_operations` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `operation_id` varchar(50) NOT NULL COMMENT 'معرف فريد للعملية',
  `admin_id` bigint(20) UNSIGNED NOT NULL,
  `operation_type` varchar(100) NOT NULL,
  `total_records` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `processed_records` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `success_count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `failed_count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `status` enum('pending','running','completed','failed','cancelled') NOT NULL DEFAULT 'pending',
  `progress_percent` decimal(5,2) NOT NULL DEFAULT 0.00,
  `started_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `error_log` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='تتبع العمليات الدفعية الكبيرة';

-- --------------------------------------------------------

--
-- بنية الجدول `blocked_broadcasts`
--

CREATE TABLE `blocked_broadcasts` (
  `id` int(10) UNSIGNED NOT NULL,
  `broadcaster_type` enum('admin','superdist') NOT NULL,
  `broadcaster_id` int(10) UNSIGNED NOT NULL,
  `broadcaster_telegram_id` bigint(20) NOT NULL,
  `content_type` varchar(20) NOT NULL COMMENT 'نوع المحتوى (text, photo, etc)',
  `content_snippet` text NOT NULL COMMENT 'مقتطف من المحتوى',
  `matched_words` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'الكلمات المطابقة من blacklist' CHECK (json_valid(`matched_words`)),
  `reason` varchar(255) NOT NULL,
  `action_taken` enum('blocked','warned','logged') NOT NULL DEFAULT 'blocked',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجل البثات المحظورة';

-- --------------------------------------------------------

--
-- بنية الجدول `broadcast_blacklist`
--

CREATE TABLE `broadcast_blacklist` (
  `id` int(10) UNSIGNED NOT NULL,
  `word` varchar(100) NOT NULL COMMENT 'الكلمة أو العبارة المحظورة',
  `type` enum('word','regex','domain') NOT NULL DEFAULT 'word' COMMENT 'نوع المطابقة',
  `severity` enum('block','warn','log') NOT NULL DEFAULT 'block' COMMENT 'مستوى الإجراء',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `added_by_admin_id` int(10) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='قائمة الكلمات المحظورة للبث';

--
-- إرجاع أو استيراد بيانات الجدول `broadcast_blacklist`
--

INSERT INTO `broadcast_blacklist` (`id`, `word`, `type`, `severity`, `is_active`, `added_by_admin_id`, `created_at`) VALUES
(1, 'porn', 'word', 'block', 1, NULL, '2025-12-03 13:04:20'),
(2, 'xxx', 'word', 'block', 1, NULL, '2025-12-03 13:04:20'),
(3, 'sex', 'word', 'block', 1, NULL, '2025-12-03 13:04:20'),
(4, 'nude', 'word', 'block', 1, NULL, '2025-12-03 13:04:20'),
(5, 'adult', 'word', 'block', 1, NULL, '2025-12-03 13:04:20'),
(6, '18+', 'word', 'block', 1, NULL, '2025-12-03 13:04:20'),
(7, 'casino', 'word', 'block', 1, NULL, '2025-12-03 13:04:20'),
(8, 'gambling', 'word', 'block', 1, NULL, '2025-12-03 13:04:20'),
(9, 't.me/joinchat', 'domain', 'warn', 1, NULL, '2025-12-03 13:04:20'),
(10, 'bit.ly', 'domain', 'warn', 1, NULL, '2025-12-03 13:04:20'),
(11, 'http://', 'word', 'warn', 1, NULL, '2025-12-03 13:04:46'),
(12, 'https://t.me/', 'word', 'warn', 1, NULL, '2025-12-03 13:04:46'),
(13, '@', 'word', 'log', 1, NULL, '2025-12-03 13:04:46');

-- --------------------------------------------------------

--
-- بنية الجدول `broadcast_errors`
--

CREATE TABLE `broadcast_errors` (
  `id` int(10) UNSIGNED NOT NULL,
  `broadcast_id` varchar(50) NOT NULL COMMENT 'معرف البث',
  `recipient_telegram_id` bigint(20) NOT NULL,
  `error_code` int(11) NOT NULL,
  `error_message` text NOT NULL,
  `retry_count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `retry_after` int(10) UNSIGNED DEFAULT NULL COMMENT 'ثواني الانتظار (لـ 429)',
  `resolved` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجل أخطاء البث';

-- --------------------------------------------------------

--
-- بنية الجدول `broadcast_logs`
--

CREATE TABLE `broadcast_logs` (
  `id` int(10) UNSIGNED NOT NULL,
  `broadcaster_type` enum('admin','superdist') NOT NULL COMMENT 'من قام بالبث',
  `broadcaster_id` varchar(64) NOT NULL COMMENT 'معرف القائم بالبث',
  `audience_type` enum('all','users','superdists','superdist_users','account_users') NOT NULL COMMENT 'نوع الجمهور',
  `audience_filter` varchar(128) DEFAULT NULL COMMENT 'فلتر إضافي (مثل superdist_id أو account_slug)',
  `content_type` enum('text','photo','video','document','audio','voice','sticker','animation') NOT NULL COMMENT 'نوع المحتوى',
  `content_text` text DEFAULT NULL COMMENT 'نص الرسالة (إن وجد)',
  `content_file_id` varchar(255) DEFAULT NULL COMMENT 'معرف الملف في تيليجرام',
  `total_recipients` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'إجمالي المستلمين المستهدفين',
  `successful_sends` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'عدد الإرسالات الناجحة',
  `failed_sends` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'عدد الإرسالات الفاشلة',
  `status` enum('pending','in_progress','completed','cancelled') NOT NULL DEFAULT 'pending' COMMENT 'حالة البث',
  `started_at` timestamp NULL DEFAULT NULL COMMENT 'وقت بدء البث',
  `completed_at` timestamp NULL DEFAULT NULL COMMENT 'وقت انتهاء البث',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `errors` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'عينة من أخطاء الإرسال (أول 10 أخطاء)' CHECK (json_valid(`errors`)),
  `content_caption` text DEFAULT NULL COMMENT 'وصف الوسائط (caption)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجلات البث الجماعي';

-- --------------------------------------------------------

--
-- بنية الجدول `broadcast_settings`
--

CREATE TABLE `broadcast_settings` (
  `id` int(10) UNSIGNED NOT NULL,
  `setting_key` varchar(50) NOT NULL,
  `setting_value` text NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='إعدادات البث';

--
-- إرجاع أو استيراد بيانات الجدول `broadcast_settings`
--

INSERT INTO `broadcast_settings` (`id`, `setting_key`, `setting_value`, `description`, `updated_at`) VALUES
(1, 'chunk_size', '30', 'عدد المستلمين في كل دفعة', '2025-12-03 13:04:20'),
(2, 'delay_between_chunks_ms', '1000', 'التأخير بين الدفعات (ميلي ثانية)', '2025-12-03 13:04:20'),
(3, 'delay_between_messages_ms', '50', 'التأخير بين الرسائل (ميلي ثانية)', '2025-12-03 13:04:20'),
(4, 'max_retries_on_429', '3', 'الحد الأقصى لإعادة المحاولة عند 429', '2025-12-03 13:04:20'),
(5, 'blacklist_enabled', '1', 'تفعيل فحص الكلمات المحظورة', '2025-12-03 13:04:20'),
(6, 'moderation_enabled', '1', 'تفعيل نظام المراقبة', '2025-12-03 13:04:20'),
(7, 'admin_bypass_blacklist', '0', 'السماح للأدمن بتجاوز القائمة السوداء', '2025-12-03 13:04:20'),
(8, 'max_message_length', '4096', NULL, '2025-12-03 13:04:46'),
(9, 'batch_size', '25', NULL, '2025-12-03 13:04:46'),
(10, 'batch_delay_ms', '50', NULL, '2025-12-03 13:04:46');

-- --------------------------------------------------------

--
-- بنية الجدول `event_logs`
--

CREATE TABLE `event_logs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `event_type` varchar(64) NOT NULL COMMENT 'نوع الحدث (انظر التوثيق أعلاه)',
  `actor_type` enum('admin','superdist','user','system') NOT NULL COMMENT 'من قام بالحدث',
  `actor_id` varchar(64) DEFAULT NULL COMMENT 'معرف الفاعل (telegram_id أو superdist_id)',
  `target_type` varchar(32) DEFAULT NULL COMMENT 'نوع الهدف (user, superdist, account, code)',
  `target_id` varchar(64) DEFAULT NULL COMMENT 'معرف الهدف',
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تفاصيل إضافية بصيغة JSON' CHECK (json_valid(`details`)),
  `ip_address` varchar(45) DEFAULT NULL COMMENT 'عنوان IP (اختياري)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجل الأحداث العام للتتبع والتدقيق';

--
-- إرجاع أو استيراد بيانات الجدول `event_logs`
--

INSERT INTO `event_logs` (`id`, `event_type`, `actor_type`, `actor_id`, `target_type`, `target_id`, `details`, `ip_address`, `created_at`) VALUES
(1, 'user_registered', 'system', NULL, 'user', '1', '{\"telegram_id\":7800599130,\"username\":\"witcher_store1\"}', '91.108.5.22', '2025-12-03 13:07:43'),
(2, 'superdist_created', 'admin', NULL, 'superdist', '1', NULL, '91.108.5.73', '2025-12-03 13:07:53'),
(3, 'unauthorized_access', 'user', '7800599130', NULL, NULL, '{\"username\":\"witcher_store1\",\"text\":\"\\/start\"}', '91.108.5.73', '2025-12-03 13:31:25'),
(4, 'superdist_subscription_activated', 'superdist', '1', 'code', 'SD-QE6Y-H8LL', '{\"accounts\":[\"greathalo2 (5 يوم)\",\"greatshinobi2 (5 يوم)\"]}', '91.108.5.22', '2025-12-03 14:46:51'),
(5, 'superdist_subscription_activated', 'superdist', '1', 'code', 'SD-QE6Y-H8LL', '{\"accounts\":[\"greathalo2 (5 يوم)\",\"greatshinobi2 (5 يوم)\"]}', '91.108.5.22', '2025-12-03 14:47:06'),
(6, 'code_generated', 'superdist', '1', 'account', '1', '{\"count\":30,\"codes\":[\"ACT-MGTW-KXLS\",\"ACT-8RFR-JD69\",\"ACT-RBUY-WX72\",\"ACT-C2ZC-DMMP\",\"ACT-MFSP-5W8V\",\"ACT-QN9C-UEFA\",\"ACT-SP7U-DWNV\",\"ACT-7442-WZKB\",\"ACT-7PX8-QDBX\",\"ACT-GLD4-6233\"]}', '91.108.5.22', '2025-12-03 15:44:00'),
(7, 'error', 'system', NULL, NULL, NULL, '{\"message\":\"Admin bot error\",\"context\":{\"message\":\"Call to undefined method Db::fetchColumn()\",\"file\":\"\\/home\\/upfovlxc\\/finaldistributorbotplus.upfolo.store\\/src\\/admin\\/BatchAccessCommands.php\",\"line\":56}}', '91.108.5.73', '2025-12-03 21:57:35'),
(8, 'error', 'system', NULL, NULL, NULL, '{\"message\":\"Admin bot error\",\"context\":{\"message\":\"Call to undefined method Db::fetchColumn()\",\"file\":\"\\/home\\/upfovlxc\\/finaldistributorbotplus.upfolo.store\\/src\\/admin\\/BatchAccessCommands.php\",\"line\":56}}', '91.108.5.73', '2025-12-03 21:57:53');

-- --------------------------------------------------------

--
-- بنية الجدول `global_settings`
--

CREATE TABLE `global_settings` (
  `id` int(10) UNSIGNED NOT NULL,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `setting_type` enum('string','int','bool','json') NOT NULL DEFAULT 'string',
  `description` varchar(255) DEFAULT NULL,
  `updated_by` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'آخر مدير قام بالتحديث',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='الإعدادات العامة للنظام';

--
-- إرجاع أو استيراد بيانات الجدول `global_settings`
--

INSERT INTO `global_settings` (`id`, `setting_key`, `setting_value`, `setting_type`, `description`, `updated_by`, `updated_at`) VALUES
(1, 'default_access_type', 'lifetime', 'string', 'نوع الوصول الافتراضي العام (lifetime أو timed)', NULL, '2025-12-03 21:39:41'),
(2, 'default_access_days', '30', 'int', 'عدد أيام الوصول الافتراضي إذا كان timed', NULL, '2025-12-03 21:39:41'),
(3, 'batch_update_chunk_size', '500', 'int', 'حجم الدفعة عند التحديث الجماعي', NULL, '2025-12-03 21:39:41'),
(4, 'batch_update_notify_users', '0', 'bool', 'إرسال إشعارات للزبائن عند التحديث الجماعي', NULL, '2025-12-03 21:39:41');

-- --------------------------------------------------------

--
-- بنية الجدول `limits_account`
--

CREATE TABLE `limits_account` (
  `id` int(10) UNSIGNED NOT NULL,
  `account_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف الحساب (FK)',
  `daily_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد اليومي (NULL = استخدم العام)',
  `weekly_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد الأسبوعي (NULL = استخدم العام)',
  `monthly_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد الشهري (NULL = استخدم العام)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='حدود الحساب (أولوية 3.5 - بين global و superdist)';

-- --------------------------------------------------------

--
-- بنية الجدول `limits_global`
--

CREATE TABLE `limits_global` (
  `id` int(10) UNSIGNED NOT NULL,
  `limit_type` enum('verification') NOT NULL DEFAULT 'verification' COMMENT 'نوع الحد',
  `daily_limit` int(10) UNSIGNED NOT NULL DEFAULT 2 COMMENT 'الحد اليومي (افتراضي: 2)',
  `weekly_limit` int(10) UNSIGNED NOT NULL DEFAULT 10 COMMENT 'الحد الأسبوعي (افتراضي: 10)',
  `monthly_limit` int(10) UNSIGNED NOT NULL DEFAULT 30 COMMENT 'الحد الشهري (افتراضي: 30)',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='الحدود العامة للنظام (أولوية 4 - الأدنى)';

--
-- إرجاع أو استيراد بيانات الجدول `limits_global`
--

INSERT INTO `limits_global` (`id`, `limit_type`, `daily_limit`, `weekly_limit`, `monthly_limit`, `updated_at`) VALUES
(1, 'verification', 2, 10, 30, '2025-12-03 13:04:09');

-- --------------------------------------------------------

--
-- بنية الجدول `limits_superdist`
--

CREATE TABLE `limits_superdist` (
  `id` int(10) UNSIGNED NOT NULL,
  `superdist_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف السوبر موزع (FK)',
  `daily_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد اليومي (NULL = استخدم العام)',
  `weekly_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد الأسبوعي (NULL = استخدم العام)',
  `monthly_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد الشهري (NULL = استخدم العام)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='حدود زبائن سوبر موزع (أولوية 3)';

-- --------------------------------------------------------

--
-- بنية الجدول `limits_user`
--

CREATE TABLE `limits_user` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف المستخدم (FK)',
  `daily_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد اليومي (NULL = استخدم الأدنى)',
  `weekly_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد الأسبوعي (NULL = استخدم الأدنى)',
  `monthly_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد الشهري (NULL = استخدم الأدنى)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='حدود المستخدم (أولوية 2)';

-- --------------------------------------------------------

--
-- بنية الجدول `limits_user_account`
--

CREATE TABLE `limits_user_account` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف المستخدم (FK)',
  `account_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف الحساب (FK)',
  `daily_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد اليومي (NULL = استخدم الأدنى)',
  `weekly_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد الأسبوعي (NULL = استخدم الأدنى)',
  `monthly_limit` int(10) UNSIGNED DEFAULT NULL COMMENT 'الحد الشهري (NULL = استخدم الأدنى)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='حدود المستخدم+الحساب (أولوية 1 - الأعلى)';

-- --------------------------------------------------------

--
-- بنية الجدول `payment_logs`
--

CREATE TABLE `payment_logs` (
  `id` int(10) UNSIGNED NOT NULL,
  `provider` varchar(50) NOT NULL COMMENT 'مزود الدفع',
  `payment_id` varchar(100) NOT NULL COMMENT 'معرف الدفع من المزود',
  `event_type` varchar(50) NOT NULL COMMENT 'نوع الحدث (payment.completed, etc)',
  `amount` decimal(10,2) NOT NULL,
  `currency` varchar(3) NOT NULL,
  `payer_email` varchar(255) DEFAULT NULL,
  `payer_name` varchar(255) DEFAULT NULL,
  `voucher_id` int(10) UNSIGNED DEFAULT NULL,
  `related_telegram_id` bigint(20) DEFAULT NULL,
  `raw_payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'البيانات الكاملة من webhook' CHECK (json_valid(`raw_payload`)),
  `signature_valid` tinyint(1) DEFAULT NULL COMMENT 'هل التوقيع صحيح',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجلات الدفع';

-- --------------------------------------------------------

--
-- بنية الجدول `process_jobs`
--

CREATE TABLE `process_jobs` (
  `id` int(10) UNSIGNED NOT NULL,
  `job_type` varchar(50) NOT NULL DEFAULT 'codes_window',
  `mode` enum('since','last_n') NOT NULL,
  `mode_value` varchar(100) NOT NULL COMMENT 'تاريخ أو عدد',
  `action` enum('expire_unused','disable_unused','report_only') NOT NULL,
  `scope_account_id` int(10) UNSIGNED DEFAULT NULL,
  `scope_superdist_id` int(10) UNSIGNED DEFAULT NULL,
  `scope_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'معلومات النطاق الإضافية' CHECK (json_valid(`scope_json`)),
  `initiated_by` int(10) UNSIGNED NOT NULL COMMENT 'admin telegram_id',
  `status` enum('pending','running','completed','failed','cancelled') NOT NULL DEFAULT 'pending',
  `progress_percent` tinyint(3) UNSIGNED DEFAULT 0,
  `total_codes` int(10) UNSIGNED DEFAULT 0,
  `processed_codes` int(10) UNSIGNED DEFAULT 0,
  `affected_codes` int(10) UNSIGNED DEFAULT 0,
  `skipped_codes` int(10) UNSIGNED DEFAULT 0,
  `result_summary_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`result_summary_json`)),
  `report_path` varchar(500) DEFAULT NULL,
  `csv_path` varchar(500) DEFAULT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `finished_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `process_job_details`
--

CREATE TABLE `process_job_details` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `job_id` int(10) UNSIGNED NOT NULL,
  `activation_code_id` int(10) UNSIGNED NOT NULL,
  `code` varchar(50) NOT NULL,
  `account_slug` varchar(100) DEFAULT NULL,
  `superdist_id` int(10) UNSIGNED DEFAULT NULL,
  `old_status` varchar(20) DEFAULT NULL,
  `new_status` varchar(20) DEFAULT NULL,
  `action_taken` varchar(50) DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `processed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `replies`
--

CREATE TABLE `replies` (
  `id` int(10) UNSIGNED NOT NULL,
  `key` varchar(64) NOT NULL COMMENT 'مفتاح الرد (مثل: WELCOME_USER)',
  `default_text` text NOT NULL COMMENT 'النص الافتراضي',
  `description` varchar(255) DEFAULT NULL COMMENT 'وصف الغرض من هذا الرد',
  `placeholders` varchar(255) DEFAULT NULL COMMENT 'المتغيرات المتاحة (مثل: {name}, {days})',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='الردود الافتراضية';

--
-- إرجاع أو استيراد بيانات الجدول `replies`
--

INSERT INTO `replies` (`id`, `key`, `default_text`, `description`, `placeholders`, `created_at`, `updated_at`) VALUES
(1, 'WELCOME_USER', 'مرحباً بك! 👋\n\nأرسل كود التفعيل الذي استلمته لتفعيل حسابك.\n\nأو أرسل /help لعرض الأوامر المتاحة.', 'رسالة الترحيب للمستخدم الجديد', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(2, 'WELCOME_SUPERDIST', 'مرحباً بك أيها الموزع! 👋\n\nأرسل /help لعرض أوامرك المتاحة.\nأرسل /my_accounts لعرض حساباتك.', 'رسالة الترحيب للسوبر موزع', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(3, 'ERROR_NOT_IN_CHANNEL', '⚠️ يجب أن تكون مشتركاً في قناتنا أولاً.\n\nاشترك في القناة ثم حاول مجدداً.', 'خطأ: غير مشترك بالقناة', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(4, 'ERROR_INVALID_CODE', '❌ الكود غير صحيح أو غير موجود.\n\nتأكد من كتابة الكود بشكل صحيح.', 'خطأ: كود غير صالح', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(5, 'ERROR_CODE_USED', '❌ هذا الكود مُستخدم مسبقاً.', 'خطأ: الكود مستخدم', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(6, 'ERROR_CODE_EXPIRED', '❌ انتهت صلاحية هذا الكود.', 'خطأ: الكود منتهي', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(7, 'ERROR_CODE_DISABLED', '❌ هذا الكود معطّل.', 'خطأ: الكود معطل', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(8, 'ERROR_NO_ACTIVE_ACCOUNTS_SUPERDIST', '⚠️ لا تملك حسابات نشطة حالياً.\n\nتواصل مع الإدارة لتجديد اشتراكك.', 'خطأ: سوبر موزع بدون حسابات نشطة', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(9, 'ERROR_ACCOUNT_NOT_ACTIVE', '❌ هذا الحساب غير نشط لديك أو انتهت صلاحيتك عليه.', 'خطأ: الحساب غير نشط للسوبر موزع', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(10, 'ERROR_ACTIVATION_LIMIT_DAILY', '⚠️ وصلت للحد اليومي لتوليد الأكواد لهذا الحساب.\n\nحاول غداً.', 'خطأ: تجاوز حد توليد الأكواد اليومي', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(11, 'ERROR_ACTIVATION_LIMIT_WEEKLY', '⚠️ وصلت للحد الأسبوعي لتوليد الأكواد لهذا الحساب.', 'خطأ: تجاوز حد توليد الأكواد الأسبوعي', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(12, 'ERROR_ACTIVATION_LIMIT_MONTHLY', '⚠️ وصلت للحد الشهري لتوليد الأكواد لهذا الحساب.', 'خطأ: تجاوز حد توليد الأكواد الشهري', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(13, 'ERROR_LIMIT_DAILY', '⚠️ وصلت للحد اليومي لطلب أكواد التحقق.\n\nحاول غداً.', 'خطأ: تجاوز حد طلب أكواد التحقق اليومي', '{limit}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(14, 'ERROR_LIMIT_WEEKLY', '⚠️ وصلت للحد الأسبوعي لطلب أكواد التحقق.', 'خطأ: تجاوز الحد الأسبوعي', '{limit}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(15, 'ERROR_LIMIT_MONTHLY', '⚠️ وصلت للحد الشهري لطلب أكواد التحقق.', 'خطأ: تجاوز الحد الشهري', '{limit}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(16, 'ERROR_ACCOUNT_EXPIRED', '⚠️ انتهت مدة اشتراكك في هذا الحساب.\n\nتحتاج إلى شراء مفتاح جديد لتجديد الوصول.', 'خطأ: انتهاء اشتراك المستخدم بالحساب', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(17, 'ERROR_ACCOUNT_NOT_OWNED', '❌ أنت لا تملك هذا الحساب.\n\nاستخدم /myaccounts لعرض حساباتك.', 'خطأ: المستخدم لا يملك الحساب', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(18, 'ERROR_USER_BANNED', '🚫 أنت محظور من استخدام هذا البوت.', 'خطأ: المستخدم محظور', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(19, 'ERROR_SUPERDIST_SUSPENDED', '⚠️ حسابك كموزع موقوف مؤقتاً.\n\nتواصل مع الإدارة.', 'خطأ: سوبر موزع موقوف', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(20, 'ERROR_SUPERDIST_BANNED', '🚫 حسابك كموزع محظور.\n\nتواصل مع الإدارة.', 'خطأ: سوبر موزع محظور', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(21, 'ERROR_SUPERDIST_ARCHIVED', '📦 حسابك كموزع مؤرشف.\n\nتواصل مع الإدارة لإعادة التفعيل.', 'خطأ: سوبر موزع مؤرشف', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(22, 'SUCCESS_ACTIVATION', '✅ تم تفعيل الحساب بنجاح!\n\nالحساب: {account_name}\nنوع الاشتراك: {access_type}\n{expiry_info}\n\nاستخدم: get_code {account_slug}\nلطلب كود التحقق.', 'نجاح تفعيل الحساب', '{account_name}, {account_slug}, {access_type}, {expiry_info}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(23, 'SUCCESS_VERIFICATION_CODE', '🔐 كود التحقق لحساب {account_name}:\n\n<code>{code}</code>\n\n⏱ صالح لمدة 30 ثانية.', 'كود التحقق', '{account_name}, {code}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(24, 'SUCCESS_CODE_GENERATED', '✅ تم توليد كود تفعيل:\n\n<code>{code}</code>\n\nللحساب: {account_name}', 'نجاح توليد كود تفعيل', '{code}, {account_name}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(25, 'SUCCESS_CODES_GENERATED', '✅ تم توليد {count} كود للحساب: {account_name}\n\nالأكواد مرفقة في الملف.', 'نجاح توليد مجموعة أكواد', '{count}, {account_name}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(26, 'INFO_BROADCAST_AWAITING_CONTENT', '📢 أرسل الآن المحتوى الذي تريد بثّه.\n\nأو أرسل /cancel للإلغاء.', 'انتظار محتوى البث', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(27, 'INFO_BROADCAST_CONFIRM', '📢 تم استلام المحتوى.\n\nنوع المحتوى: {content_type}\nعدد المستلمين: {recipients_count}\n\nأرسل \"تأكيد\" للإرسال.\nأرسل \"تعديل\" لتغيير المحتوى.\nأرسل /cancel للإلغاء.', 'تأكيد البث', '{content_type}, {recipients_count}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(28, 'INFO_BROADCAST_STARTED', '🚀 بدأ البث...\n\nسيتم إرسال الرسائل على دفعات.', 'بدء البث', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(29, 'INFO_BROADCAST_DONE', '✅ اكتمل البث!\n\nنجح: {success}\nفشل: {failed}\nالإجمالي: {total}', 'انتهاء البث', '{success}, {failed}, {total}', '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(30, 'INFO_BROADCAST_CANCELLED', '❌ تم إلغاء البث.', 'إلغاء البث', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(31, 'HELP_USER', '📋 <b>الأوامر المتاحة:</b>\n\n<b>تفعيل الحسابات:</b>\n• أرسل كود التفعيل (ACT-...) مباشرة\n\n<b>الحسابات:</b>\n• <code>/myaccounts</code> - عرض حساباتك\n• <code>/account_info [slug]</code> - تفاصيل حساب\n\n<b>طلب كود التحقق:</b>\n• <code>get_code [slug]</code> - أو أرسل الـ slug مباشرة', 'مساعدة المستخدم', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09'),
(32, 'HELP_SUPERDIST', '📋 <b>أوامر الموزع:</b>\n\n<b>عرض المعلومات:</b>\n• <code>/my_accounts</code> - حساباتك المرتبطة\n• <code>/mystatus</code> - حالتك وإحصائياتك\n• <code>/my_remaining</code> - الحدود المتبقية\n\n<b>توليد الأكواد:</b>\n• <code>gen_code [slug]</code> - كود واحد\n• <code>gen_codes [slug] [count]</code> - مجموعة أكواد\n• <code>/my_codes [slug] [page]</code> - عرض أكوادك\n• <code>/check_code [code]</code> - فحص كود\n\n<b>البث:</b>\n• <code>/broadcast</code> - بث لجميع زبائنك\n• <code>/broadcast_my_account [slug]</code> - بث لزبائن حساب معين\n\n<b>كود الاشتراك:</b>\n• أرسل الكود (SD-...) لتفعيل/تجديد حساباتك', 'مساعدة السوبر موزع', NULL, '2025-12-03 13:04:09', '2025-12-03 13:04:09');

-- --------------------------------------------------------

--
-- بنية الجدول `superdist_accounts`
--

CREATE TABLE `superdist_accounts` (
  `id` int(10) UNSIGNED NOT NULL,
  `superdist_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف السوبر موزع',
  `account_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف الحساب',
  `start_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'بداية فترة النشاط',
  `duration_days` int(10) UNSIGNED NOT NULL COMMENT 'عدد أيام الصلاحية',
  `end_at` timestamp NOT NULL COMMENT 'نهاية فترة النشاط (يُحسب في PHP: start_at + duration_days)',
  `activation_limit_daily` int(10) UNSIGNED DEFAULT NULL COMMENT 'حد توليد الأكواد اليومي (NULL = بلا حد)',
  `activation_limit_weekly` int(10) UNSIGNED DEFAULT NULL COMMENT 'حد توليد الأكواد الأسبوعي',
  `activation_limit_monthly` int(10) UNSIGNED DEFAULT NULL COMMENT 'حد توليد الأكواد الشهري',
  `activations_today` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'عدد الأكواد المولّدة اليوم',
  `activations_this_week` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'عدد الأكواد المولّدة هذا الأسبوع',
  `activations_this_month` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'عدد الأكواد المولّدة هذا الشهر',
  `last_daily_reset` date DEFAULT NULL COMMENT 'تاريخ آخر تصفير يومي',
  `last_weekly_reset` char(6) DEFAULT NULL COMMENT 'آخر تصفير أسبوعي (YYYYWW format)',
  `last_monthly_reset` char(6) DEFAULT NULL COMMENT 'آخر تصفير شهري (YYYYMM format)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='ربط السوبر موزع بالحسابات مع الفترات والحدود';

-- --------------------------------------------------------

--
-- بنية الجدول `superdist_replies`
--

CREATE TABLE `superdist_replies` (
  `id` int(10) UNSIGNED NOT NULL,
  `superdist_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف السوبر موزع',
  `reply_key` varchar(64) NOT NULL COMMENT 'مفتاح الرد',
  `custom_text` text NOT NULL COMMENT 'النص المخصص',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='ردود مخصصة لسوبر موزع';

-- --------------------------------------------------------

--
-- بنية الجدول `superdist_subscription_codes`
--

CREATE TABLE `superdist_subscription_codes` (
  `id` int(10) UNSIGNED NOT NULL,
  `code` varchar(32) NOT NULL COMMENT 'الكود الفريد (مثل: SD-ABCD-1234)',
  `code_type` enum('new','upgrade') NOT NULL COMMENT 'نوع الكود: new=إنشاء جديد، upgrade=ترقية/تمديد',
  `accounts_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'بيانات الحسابات [{account_id, duration_days}, ...]' CHECK (json_valid(`accounts_data`)),
  `max_uses` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT 'عدد الاستخدامات المسموحة',
  `current_uses` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'عدد الاستخدامات الحالية',
  `expires_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ انتهاء صلاحية الكود (NULL = لا ينتهي)',
  `status` enum('unused','partial','used','expired','disabled') NOT NULL DEFAULT 'unused' COMMENT 'حالة الكود',
  `used_by_superdist_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'السوبر موزع الذي استخدم الكود',
  `used_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ الاستخدام',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(64) DEFAULT 'admin' COMMENT 'من أنشأ الكود'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='أكواد اشتراك السوبر موزعين';

--
-- إرجاع أو استيراد بيانات الجدول `superdist_subscription_codes`
--

INSERT INTO `superdist_subscription_codes` (`id`, `code`, `code_type`, `accounts_data`, `max_uses`, `current_uses`, `expires_at`, `status`, `used_by_superdist_id`, `used_at`, `created_at`, `created_by`) VALUES
(1, 'SD-QE6Y-H8LL', 'new', '[{\"account_id\":1,\"duration_days\":5},{\"account_id\":2,\"duration_days\":5}]', 2, 2, NULL, 'used', 1, '2025-12-03 22:47:06', '2025-12-03 14:46:34', 'admin');

-- --------------------------------------------------------

--
-- بنية الجدول `super_distributors`
--

CREATE TABLE `super_distributors` (
  `id` int(10) UNSIGNED NOT NULL,
  `telegram_id` bigint(20) NOT NULL COMMENT 'معرف تيليجرام للسوبر موزع',
  `username` varchar(64) DEFAULT NULL COMMENT 'اسم المستخدم في تيليجرام',
  `display_name` varchar(128) NOT NULL COMMENT 'الاسم المعروض في التقارير',
  `status` enum('active','suspended','banned','archived') NOT NULL DEFAULT 'active' COMMENT 'حالة السوبر موزع',
  `status_reason` varchar(255) DEFAULT NULL COMMENT 'سبب تغيير الحالة',
  `status_changed_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ آخر تغيير للحالة',
  `can_broadcast` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'هل يُسمح له بالبث؟',
  `broadcast_allowed_types` text DEFAULT NULL COMMENT 'JSON array: ["text","stickers","photos","videos","documents","audio"]',
  `broadcast_content_type` enum('text_only','text_images','all') NOT NULL DEFAULT 'text_only' COMMENT 'أنواع المحتوى المسموحة للبث',
  `can_ban_users` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'هل يُسمح له بحظر زبائنه؟',
  `notes` text DEFAULT NULL COMMENT 'ملاحظات إدارية',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول السوبر موزعين';

--
-- إرجاع أو استيراد بيانات الجدول `super_distributors`
--

INSERT INTO `super_distributors` (`id`, `telegram_id`, `username`, `display_name`, `status`, `status_reason`, `status_changed_at`, `can_broadcast`, `broadcast_allowed_types`, `broadcast_content_type`, `can_ban_users`, `notes`, `created_at`, `updated_at`) VALUES
(1, 7800599130, NULL, 'ويتشر ستور', 'active', NULL, NULL, 1, '[\"text\",\"stickers\",\"photos\",\"videos\",\"documents\",\"audio\"]', 'text_only', 0, NULL, '2025-12-03 13:07:53', '2025-12-03 13:07:53');

-- --------------------------------------------------------

--
-- بنية الجدول `system_check_reports`
--

CREATE TABLE `system_check_reports` (
  `id` int(10) UNSIGNED NOT NULL,
  `check_type` enum('full','quick','custom') NOT NULL DEFAULT 'full',
  `triggered_by` enum('admin','cron','api','cli') NOT NULL,
  `triggered_by_admin_id` int(10) UNSIGNED DEFAULT NULL,
  `total_tests` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `passed_tests` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `failed_tests` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `warnings` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `results` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'نتائج كل اختبار بالتفصيل' CHECK (json_valid(`results`)),
  `summary` text NOT NULL COMMENT 'ملخص نصي',
  `recommendations` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'توصيات الإصلاح' CHECK (json_valid(`recommendations`)),
  `report_file_json` varchar(255) DEFAULT NULL COMMENT 'مسار ملف JSON',
  `report_file_txt` varchar(255) DEFAULT NULL COMMENT 'مسار ملف TXT',
  `duration_ms` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'مدة التنفيذ بالميلي ثانية',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='تقارير فحص النظام';

-- --------------------------------------------------------

--
-- بنية الجدول `system_settings`
--

CREATE TABLE `system_settings` (
  `id` int(10) UNSIGNED NOT NULL,
  `level` enum('global','account','superdist','user','user_account') NOT NULL,
  `level_id` varchar(100) DEFAULT NULL COMMENT 'معرف المستوى (null للـ global)',
  `level_id_secondary` varchar(100) DEFAULT NULL COMMENT 'معرف ثانوي (للـ user_account)',
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text NOT NULL,
  `value_type` enum('string','int','float','bool','json','array') NOT NULL DEFAULT 'string',
  `updated_by` int(10) UNSIGNED DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `system_settings`
--

INSERT INTO `system_settings` (`id`, `level`, `level_id`, `level_id_secondary`, `setting_key`, `setting_value`, `value_type`, `updated_by`, `updated_at`, `created_at`) VALUES
(1, 'global', NULL, NULL, 'activation_default_type', 'lifetime', 'string', NULL, '2025-12-03 13:04:32', '2025-12-03 13:04:32'),
(2, 'global', NULL, NULL, 'activation_default_days', '30', 'int', NULL, '2025-12-03 13:04:32', '2025-12-03 13:04:32'),
(3, 'global', NULL, NULL, 'voucher_redeem_allowed', 'true', 'bool', NULL, '2025-12-03 13:04:32', '2025-12-03 13:04:32'),
(4, 'global', NULL, NULL, 'broadcast_allowed_types', '[\"text\",\"stickers\",\"photos\",\"videos\",\"documents\",\"audio\"]', 'json', NULL, '2025-12-03 13:04:32', '2025-12-03 13:04:32'),
(5, 'global', NULL, NULL, 'max_codes_per_generation', '100', 'int', NULL, '2025-12-03 13:04:32', '2025-12-03 13:04:32'),
(6, 'global', NULL, NULL, 'code_expiry_days', '365', 'int', NULL, '2025-12-03 13:04:32', '2025-12-03 13:04:32');

-- --------------------------------------------------------

--
-- بنية الجدول `users`
--

CREATE TABLE `users` (
  `id` int(10) UNSIGNED NOT NULL,
  `telegram_id` bigint(20) NOT NULL COMMENT 'معرف تيليجرام للمستخدم',
  `username` varchar(64) DEFAULT NULL COMMENT 'اسم المستخدم في تيليجرام (بدون @)',
  `first_name` varchar(128) DEFAULT NULL COMMENT 'الاسم الأول',
  `last_name` varchar(128) DEFAULT NULL COMMENT 'الاسم الأخير',
  `status` enum('active','banned') NOT NULL DEFAULT 'active' COMMENT 'حالة المستخدم',
  `ban_reason` varchar(255) DEFAULT NULL COMMENT 'سبب الحظر (إن وجد)',
  `banned_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ الحظر',
  `banned_by` varchar(64) DEFAULT NULL COMMENT 'من قام بالحظر (admin/superdist_id)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول المستخدمين/الزبائن';

--
-- إرجاع أو استيراد بيانات الجدول `users`
--

INSERT INTO `users` (`id`, `telegram_id`, `username`, `first_name`, `last_name`, `status`, `ban_reason`, `banned_at`, `banned_by`, `created_at`, `updated_at`) VALUES
(1, 7800599130, 'witcher_store1', 'تواصل ويتشر ستور', NULL, 'active', NULL, NULL, NULL, '2025-12-03 13:07:43', '2025-12-03 13:07:43');

-- --------------------------------------------------------

--
-- بنية الجدول `user_accounts`
--

CREATE TABLE `user_accounts` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف المستخدم',
  `account_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف الحساب',
  `superdist_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'السوبر موزع الذي أعطاه الكود',
  `activation_code_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'كود التفعيل المستخدم',
  `access_type` enum('lifetime','timed') NOT NULL DEFAULT 'lifetime',
  `access_days` int(10) UNSIGNED DEFAULT NULL,
  `activated_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'تاريخ التفعيل',
  `access_expires_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ انتهاء الاشتراك (محسوب للـ timed)',
  `status` enum('active','expired','revoked') NOT NULL DEFAULT 'active' COMMENT 'حالة الاشتراك',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='اشتراكات المستخدمين في الحسابات';

-- --------------------------------------------------------

--
-- بنية الجدول `user_states`
--

CREATE TABLE `user_states` (
  `id` int(10) UNSIGNED NOT NULL,
  `telegram_id` bigint(20) NOT NULL COMMENT 'معرف تيليجرام',
  `user_type` enum('admin','superdist','user') NOT NULL COMMENT 'نوع المستخدم',
  `state` varchar(64) NOT NULL COMMENT 'الحالة الحالية (مثل: awaiting_broadcast_content)',
  `state_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'بيانات الحالة (مثل: نوع الجمهور، المحتوى المؤقت)' CHECK (json_valid(`state_data`)),
  `expires_at` timestamp NULL DEFAULT NULL COMMENT 'انتهاء صلاحية الحالة',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='حالات الجلسات المؤقتة';

-- --------------------------------------------------------

--
-- بنية الجدول `verification_logs`
--

CREATE TABLE `verification_logs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف المستخدم',
  `account_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف الحساب',
  `superdist_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'السوبر موزع المصدر (للإحصائيات)',
  `verification_code` varchar(16) DEFAULT NULL COMMENT 'الكود المُولَّد (اختياري للتتبع)',
  `requested_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'وقت الطلب',
  `ip_address` varchar(45) DEFAULT NULL COMMENT 'عنوان IP (اختياري)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجلات طلب أكواد التحقق';

-- --------------------------------------------------------

--
-- بنية الجدول `vouchers`
--

CREATE TABLE `vouchers` (
  `id` int(10) UNSIGNED NOT NULL,
  `code` varchar(32) NOT NULL COMMENT 'كود القسيمة الفريد (مثل: VCH-XXXX-XXXX)',
  `type` enum('sd','activation_bundle') NOT NULL COMMENT 'sd=اشتراك موزع، activation_bundle=حزمة أكواد',
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'بيانات القسيمة حسب النوع' CHECK (json_valid(`payload`)),
  `max_uses` int(10) UNSIGNED NOT NULL DEFAULT 1 COMMENT 'الحد الأقصى للاستخدام',
  `current_uses` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'عدد مرات الاستخدام الحالية',
  `status` enum('unused','partial','used','expired','disabled') NOT NULL DEFAULT 'unused',
  `expires_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ انتهاء صلاحية القسيمة',
  `payment_id` varchar(100) DEFAULT NULL COMMENT 'معرف الدفع الخارجي',
  `payment_provider` varchar(50) DEFAULT NULL COMMENT 'مزود الدفع (stripe, paypal, etc)',
  `payment_amount` decimal(10,2) DEFAULT NULL COMMENT 'مبلغ الدفع',
  `payment_currency` varchar(3) DEFAULT NULL COMMENT 'عملة الدفع',
  `payment_status` enum('pending','completed','failed','refunded') DEFAULT NULL,
  `created_by_admin_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'معرف المسؤول الذي أنشأ القسيمة',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول القسائم والباقات';

-- --------------------------------------------------------

--
-- بنية الجدول `voucher_codes`
--

CREATE TABLE `voucher_codes` (
  `id` int(10) UNSIGNED NOT NULL,
  `voucher_id` int(10) UNSIGNED NOT NULL,
  `activation_code_id` int(10) UNSIGNED NOT NULL COMMENT 'معرف كود التفعيل المولد',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='أكواد التفعيل المولدة من القسائم';

-- --------------------------------------------------------

--
-- بنية الجدول `voucher_redemptions`
--

CREATE TABLE `voucher_redemptions` (
  `id` int(10) UNSIGNED NOT NULL,
  `voucher_id` int(10) UNSIGNED NOT NULL,
  `redeemer_telegram_id` bigint(20) NOT NULL COMMENT 'Telegram ID للمستفيد',
  `redeemer_type` enum('superdist','user') NOT NULL COMMENT 'نوع المستفيد',
  `redeemer_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'ID في جدول super_distributors أو users',
  `result` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'تفاصيل ما تم إنشاؤه/تفعيله' CHECK (json_valid(`result`)),
  `redeemed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجلات استخدام القسائم';

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_accounts_inherit_global`
-- (See below for the actual view)
--
CREATE TABLE `v_accounts_inherit_global` (
`id` int(10) unsigned
,`slug` varchar(64)
,`name` varchar(128)
,`default_inherit_global` tinyint(1)
,`default_access_type` enum('lifetime','timed')
,`default_access_days` int(10) unsigned
,`active_users_count` bigint(21)
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_recent_admin_audits`
-- (See below for the actual view)
--
CREATE TABLE `v_recent_admin_audits` (
`id` bigint(20) unsigned
,`admin_telegram_id` bigint(20)
,`action` varchar(100)
,`target_type` varchar(50)
,`affected_count` int(10) unsigned
,`is_preview` tinyint(1)
,`status` enum('success','partial','failed')
,`created_at` timestamp
,`seconds_ago` bigint(21)
);

--
-- Indexes for dumped tables
--

--
-- فهارس للجدول `accounts`
--
ALTER TABLE `accounts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_slug` (`slug`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_inherit_global` (`default_inherit_global`);

--
-- فهارس للجدول `activation_codes`
--
ALTER TABLE `activation_codes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_code` (`code`),
  ADD KEY `idx_superdist_id` (`superdist_id`),
  ADD KEY `idx_account_id` (`account_id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_expires_at` (`expires_at`),
  ADD KEY `idx_superdist_account_status` (`superdist_id`,`account_id`,`status`),
  ADD KEY `fk_ac_user` (`used_by_user_id`),
  ADD KEY `idx_ac_superdist_status_created` (`superdist_id`,`status`,`created_at`),
  ADD KEY `idx_ac_status_created` (`status`,`created_at`),
  ADD KEY `idx_ac_account_status` (`account_id`,`status`),
  ADD KEY `idx_ac_superdist_status` (`superdist_id`,`status`);

--
-- فهارس للجدول `admin_audit`
--
ALTER TABLE `admin_audit`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_admin_id` (`admin_id`),
  ADD KEY `idx_action` (`action`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `idx_target_type` (`target_type`);

--
-- فهارس للجدول `bans`
--
ALTER TABLE `bans`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_target` (`target_type`,`target_id`),
  ADD KEY `idx_telegram_id` (`target_telegram_id`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `idx_banned_at` (`banned_at`);

--
-- فهارس للجدول `batch_operations`
--
ALTER TABLE `batch_operations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `operation_id` (`operation_id`),
  ADD UNIQUE KEY `uk_operation_id` (`operation_id`),
  ADD KEY `idx_admin_id` (`admin_id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- فهارس للجدول `blocked_broadcasts`
--
ALTER TABLE `blocked_broadcasts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_broadcaster` (`broadcaster_type`,`broadcaster_id`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- فهارس للجدول `broadcast_blacklist`
--
ALTER TABLE `broadcast_blacklist`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_word` (`word`),
  ADD KEY `idx_type` (`type`),
  ADD KEY `idx_is_active` (`is_active`);

--
-- فهارس للجدول `broadcast_errors`
--
ALTER TABLE `broadcast_errors`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_broadcast_id` (`broadcast_id`),
  ADD KEY `idx_error_code` (`error_code`),
  ADD KEY `idx_resolved` (`resolved`);

--
-- فهارس للجدول `broadcast_logs`
--
ALTER TABLE `broadcast_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_broadcaster` (`broadcaster_type`,`broadcaster_id`),
  ADD KEY `idx_audience_type` (`audience_type`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- فهارس للجدول `broadcast_settings`
--
ALTER TABLE `broadcast_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_setting_key` (`setting_key`);

--
-- فهارس للجدول `event_logs`
--
ALTER TABLE `event_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_event_type` (`event_type`),
  ADD KEY `idx_actor` (`actor_type`,`actor_id`),
  ADD KEY `idx_target` (`target_type`,`target_id`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- فهارس للجدول `global_settings`
--
ALTER TABLE `global_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`),
  ADD UNIQUE KEY `uk_setting_key` (`setting_key`);

--
-- فهارس للجدول `limits_account`
--
ALTER TABLE `limits_account`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_account_id` (`account_id`);

--
-- فهارس للجدول `limits_global`
--
ALTER TABLE `limits_global`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_limit_type` (`limit_type`);

--
-- فهارس للجدول `limits_superdist`
--
ALTER TABLE `limits_superdist`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_superdist_id` (`superdist_id`);

--
-- فهارس للجدول `limits_user`
--
ALTER TABLE `limits_user`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_user_id` (`user_id`);

--
-- فهارس للجدول `limits_user_account`
--
ALTER TABLE `limits_user_account`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_user_account` (`user_id`,`account_id`),
  ADD KEY `idx_account_id` (`account_id`);

--
-- فهارس للجدول `payment_logs`
--
ALTER TABLE `payment_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_provider` (`provider`),
  ADD KEY `idx_payment_id` (`payment_id`),
  ADD KEY `idx_voucher_id` (`voucher_id`);

--
-- فهارس للجدول `process_jobs`
--
ALTER TABLE `process_jobs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_initiated_by` (`initiated_by`),
  ADD KEY `idx_created` (`created_at`);

--
-- فهارس للجدول `process_job_details`
--
ALTER TABLE `process_job_details`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_job_id` (`job_id`),
  ADD KEY `idx_code` (`code`);

--
-- فهارس للجدول `replies`
--
ALTER TABLE `replies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_key` (`key`);

--
-- فهارس للجدول `superdist_accounts`
--
ALTER TABLE `superdist_accounts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_superdist_account` (`superdist_id`,`account_id`),
  ADD KEY `idx_account_id` (`account_id`),
  ADD KEY `idx_end_at` (`end_at`);

--
-- فهارس للجدول `superdist_replies`
--
ALTER TABLE `superdist_replies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_superdist_key` (`superdist_id`,`reply_key`);

--
-- فهارس للجدول `superdist_subscription_codes`
--
ALTER TABLE `superdist_subscription_codes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_code` (`code`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_code_type` (`code_type`),
  ADD KEY `idx_expires_at` (`expires_at`),
  ADD KEY `fk_ssc_superdist` (`used_by_superdist_id`);

--
-- فهارس للجدول `super_distributors`
--
ALTER TABLE `super_distributors`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_telegram_id` (`telegram_id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_username` (`username`);

--
-- فهارس للجدول `system_check_reports`
--
ALTER TABLE `system_check_reports`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_check_type` (`check_type`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- فهارس للجدول `system_settings`
--
ALTER TABLE `system_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_setting` (`level`,`level_id`,`level_id_secondary`,`setting_key`),
  ADD KEY `idx_level` (`level`),
  ADD KEY `idx_key` (`setting_key`);

--
-- فهارس للجدول `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_telegram_id` (`telegram_id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_username` (`username`);

--
-- فهارس للجدول `user_accounts`
--
ALTER TABLE `user_accounts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_user_account` (`user_id`,`account_id`),
  ADD KEY `idx_account_id` (`account_id`),
  ADD KEY `idx_superdist_id` (`superdist_id`),
  ADD KEY `idx_access_expires_at` (`access_expires_at`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `fk_ua_activation_code` (`activation_code_id`),
  ADD KEY `idx_access_type` (`access_type`),
  ADD KEY `idx_access_expires` (`access_expires_at`);

--
-- فهارس للجدول `user_states`
--
ALTER TABLE `user_states`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_telegram_id` (`telegram_id`),
  ADD KEY `idx_state` (`state`),
  ADD KEY `idx_expires_at` (`expires_at`);

--
-- فهارس للجدول `verification_logs`
--
ALTER TABLE `verification_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_account_id` (`account_id`),
  ADD KEY `idx_superdist_id` (`superdist_id`),
  ADD KEY `idx_requested_at` (`requested_at`),
  ADD KEY `idx_user_account_date` (`user_id`,`account_id`,`requested_at`),
  ADD KEY `idx_vl_user_account_period` (`user_id`,`account_id`,`requested_at`);

--
-- فهارس للجدول `vouchers`
--
ALTER TABLE `vouchers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_code` (`code`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_type` (`type`),
  ADD KEY `idx_payment_id` (`payment_id`),
  ADD KEY `idx_expires_at` (`expires_at`);

--
-- فهارس للجدول `voucher_codes`
--
ALTER TABLE `voucher_codes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_voucher_id` (`voucher_id`),
  ADD KEY `idx_activation_code_id` (`activation_code_id`);

--
-- فهارس للجدول `voucher_redemptions`
--
ALTER TABLE `voucher_redemptions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_voucher_id` (`voucher_id`),
  ADD KEY `idx_redeemer_telegram_id` (`redeemer_telegram_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `accounts`
--
ALTER TABLE `accounts`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=96;

--
-- AUTO_INCREMENT for table `activation_codes`
--
ALTER TABLE `activation_codes`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=31;

--
-- AUTO_INCREMENT for table `admin_audit`
--
ALTER TABLE `admin_audit`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT for table `bans`
--
ALTER TABLE `bans`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `batch_operations`
--
ALTER TABLE `batch_operations`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `blocked_broadcasts`
--
ALTER TABLE `blocked_broadcasts`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `broadcast_blacklist`
--
ALTER TABLE `broadcast_blacklist`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `broadcast_errors`
--
ALTER TABLE `broadcast_errors`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `broadcast_logs`
--
ALTER TABLE `broadcast_logs`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `broadcast_settings`
--
ALTER TABLE `broadcast_settings`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `event_logs`
--
ALTER TABLE `event_logs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `global_settings`
--
ALTER TABLE `global_settings`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `limits_account`
--
ALTER TABLE `limits_account`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `limits_global`
--
ALTER TABLE `limits_global`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `limits_superdist`
--
ALTER TABLE `limits_superdist`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `limits_user`
--
ALTER TABLE `limits_user`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `limits_user_account`
--
ALTER TABLE `limits_user_account`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment_logs`
--
ALTER TABLE `payment_logs`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `process_jobs`
--
ALTER TABLE `process_jobs`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `process_job_details`
--
ALTER TABLE `process_job_details`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `replies`
--
ALTER TABLE `replies`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=33;

--
-- AUTO_INCREMENT for table `superdist_accounts`
--
ALTER TABLE `superdist_accounts`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `superdist_replies`
--
ALTER TABLE `superdist_replies`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `superdist_subscription_codes`
--
ALTER TABLE `superdist_subscription_codes`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `super_distributors`
--
ALTER TABLE `super_distributors`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `system_check_reports`
--
ALTER TABLE `system_check_reports`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `system_settings`
--
ALTER TABLE `system_settings`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `user_accounts`
--
ALTER TABLE `user_accounts`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_states`
--
ALTER TABLE `user_states`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `verification_logs`
--
ALTER TABLE `verification_logs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vouchers`
--
ALTER TABLE `vouchers`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `voucher_codes`
--
ALTER TABLE `voucher_codes`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `voucher_redemptions`
--
ALTER TABLE `voucher_redemptions`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

-- --------------------------------------------------------

--
-- Structure for view `v_accounts_inherit_global`
--
DROP TABLE IF EXISTS `v_accounts_inherit_global`;

CREATE ALGORITHM=UNDEFINED DEFINER=`cpses_updxvhqs5g`@`localhost` SQL SECURITY DEFINER VIEW `v_accounts_inherit_global`  AS SELECT `a`.`id` AS `id`, `a`.`slug` AS `slug`, `a`.`name` AS `name`, `a`.`default_inherit_global` AS `default_inherit_global`, `a`.`default_access_type` AS `default_access_type`, `a`.`default_access_days` AS `default_access_days`, count(distinct `ua`.`user_id`) AS `active_users_count` FROM (`accounts` `a` left join `user_accounts` `ua` on(`a`.`id` = `ua`.`account_id`)) WHERE `a`.`default_inherit_global` = 1 GROUP BY `a`.`id`, `a`.`slug`, `a`.`name`, `a`.`default_inherit_global`, `a`.`default_access_type`, `a`.`default_access_days` ;

-- --------------------------------------------------------

--
-- Structure for view `v_recent_admin_audits`
--
DROP TABLE IF EXISTS `v_recent_admin_audits`;

CREATE ALGORITHM=UNDEFINED DEFINER=`cpses_updxvhqs5g`@`localhost` SQL SECURITY DEFINER VIEW `v_recent_admin_audits`  AS SELECT `aa`.`id` AS `id`, `aa`.`admin_telegram_id` AS `admin_telegram_id`, `aa`.`action` AS `action`, `aa`.`target_type` AS `target_type`, `aa`.`affected_count` AS `affected_count`, `aa`.`is_preview` AS `is_preview`, `aa`.`status` AS `status`, `aa`.`created_at` AS `created_at`, timestampdiff(SECOND,`aa`.`created_at`,current_timestamp()) AS `seconds_ago` FROM `admin_audit` AS `aa` ORDER BY `aa`.`created_at` DESC LIMIT 0, 100 ;

--
-- القيود المفروضة على الجداول الملقاة
--

--
-- قيود الجداول `activation_codes`
--
ALTER TABLE `activation_codes`
  ADD CONSTRAINT `fk_ac_account` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_ac_superdist` FOREIGN KEY (`superdist_id`) REFERENCES `super_distributors` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_ac_user` FOREIGN KEY (`used_by_user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- قيود الجداول `limits_account`
--
ALTER TABLE `limits_account`
  ADD CONSTRAINT `fk_la_account` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `limits_superdist`
--
ALTER TABLE `limits_superdist`
  ADD CONSTRAINT `fk_ls_superdist` FOREIGN KEY (`superdist_id`) REFERENCES `super_distributors` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `limits_user`
--
ALTER TABLE `limits_user`
  ADD CONSTRAINT `fk_lu_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `limits_user_account`
--
ALTER TABLE `limits_user_account`
  ADD CONSTRAINT `fk_lua_account` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_lua_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `process_job_details`
--
ALTER TABLE `process_job_details`
  ADD CONSTRAINT `fk_pjd_job` FOREIGN KEY (`job_id`) REFERENCES `process_jobs` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `superdist_accounts`
--
ALTER TABLE `superdist_accounts`
  ADD CONSTRAINT `fk_sa_account` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_sa_superdist` FOREIGN KEY (`superdist_id`) REFERENCES `super_distributors` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `superdist_replies`
--
ALTER TABLE `superdist_replies`
  ADD CONSTRAINT `fk_sr_superdist` FOREIGN KEY (`superdist_id`) REFERENCES `super_distributors` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `superdist_subscription_codes`
--
ALTER TABLE `superdist_subscription_codes`
  ADD CONSTRAINT `fk_ssc_superdist` FOREIGN KEY (`used_by_superdist_id`) REFERENCES `super_distributors` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- قيود الجداول `user_accounts`
--
ALTER TABLE `user_accounts`
  ADD CONSTRAINT `fk_ua_account` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_ua_activation_code` FOREIGN KEY (`activation_code_id`) REFERENCES `activation_codes` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_ua_superdist` FOREIGN KEY (`superdist_id`) REFERENCES `super_distributors` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_ua_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `verification_logs`
--
ALTER TABLE `verification_logs`
  ADD CONSTRAINT `fk_vl_account` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_vl_superdist` FOREIGN KEY (`superdist_id`) REFERENCES `super_distributors` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_vl_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `voucher_codes`
--
ALTER TABLE `voucher_codes`
  ADD CONSTRAINT `fk_vc_activation` FOREIGN KEY (`activation_code_id`) REFERENCES `activation_codes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_vc_voucher` FOREIGN KEY (`voucher_id`) REFERENCES `vouchers` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `voucher_redemptions`
--
ALTER TABLE `voucher_redemptions`
  ADD CONSTRAINT `fk_vr_voucher` FOREIGN KEY (`voucher_id`) REFERENCES `vouchers` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
