# مهام Cron (Cron Jobs)

## نظرة عامة

هذا المجلد يحتوي على سكربتات PHP للمهام المجدولة.

---

## قائمة المهام

| الملف | الوظيفة | التوقيت |
|-------|---------|---------|
| `daily_reset.php` | تصفير يومي + تنظيف | `0 0 * * *` (منتصف الليل) |
| `weekly_reset.php` | تصفير أسبوعي | `0 0 * * 6` (كل سبت) |
| `monthly_reset.php` | تصفير شهري | `0 0 1 * *` (أول الشهر) |
| `superdist_expiry.php` | انتهاء حسابات SD | `0 1 * * *` (01:00) |
| `cleanup.php` | تنظيف عام | `0 3 * * *` (03:00) |

---

## التوثيق

### daily_reset.php
- تصفير `activations_today` في `superdist_accounts`
- تحديث الأكواد المنتهية
- تحديث اشتراكات المستخدمين المنتهية
- تنظيف `user_states` القديمة

### weekly_reset.php
- تصفير `activations_week` في `superdist_accounts`

### monthly_reset.php
- تصفير `activations_month` في `superdist_accounts`

### superdist_expiry.php
- تحويل الأكواد غير المستخدمة لحسابات SD المنتهية إلى `expired`
- (اختياري) إرسال تنبيهات قبل الانتهاء

### cleanup.php
- حذف ملفات temp القديمة
- حذف سجلات الأحداث القديمة (90+ يوم)
- حذف سجلات التحقق القديمة (30+ يوم)

---

## إعداد cPanel

1. افتح: cPanel → Cron Jobs
2. أضف كل مهمة بالتوقيت المناسب
3. استبدل المسار بمسارك الفعلي

### مثال
```
0 0 * * * /usr/bin/php /home/username/public_html/cron/daily_reset.php >> /home/username/logs/cron_daily.log 2>&1
```

---

## التشغيل اليدوي

```bash
php /path/to/cron/daily_reset.php
```

---

## استكشاف الأخطاء

1. تأكد من مسار PHP الصحيح (`/usr/bin/php` أو `php`)
2. تأكد من صلاحيات الملفات
3. راجع ملفات السجلات
