<?php
/**
 * ============================================================
 * ملف إعدادات البيئة (Environment Configuration)
 * ============================================================
 * 
 * هذا الملف يحتوي جميع الإعدادات الحساسة للنظام.
 * يجب حمايته من الوصول المباشر عبر المتصفح.
 * 
 * الاستخدام:
 *   $config = require __DIR__ . '/config/env.php';
 *   $dbHost = $config['DB_HOST'];
 * 
 * ============================================================
 * الحقول الأساسية المطلوبة (REQUIRED):
 * ============================================================
 * 
 * قاعدة البيانات:
 *   - DB_HOST     : string - مضيف قاعدة البيانات
 *   - DB_NAME     : string - اسم قاعدة البيانات
 *   - DB_USER     : string - اسم مستخدم قاعدة البيانات
 *   - DB_PASS     : string - كلمة مرور قاعدة البيانات
 * 
 * البوتات:
 *   - ADMIN_BOT_TOKEN  : string - توكن بوت الإدارة
 *   - PUBLIC_BOT_TOKEN : string - توكن البوت العام
 * 
 * قناة التفعيل:
 *   - CHANNEL_ID   : string|int - معرف القناة (-100xxx أو @username)
 *   - CHANNEL_LINK : string - رابط القناة للعرض في الرسائل
 * 
 * المسؤولون:
 *   - ADMIN_IDS : array<int> - مصفوفة معرفات تيليجرام للمسؤولين
 * 
 * ============================================================
 */

return [
    // ============================================================
    // إعدادات قاعدة البيانات
    // ============================================================
    'DB_HOST'     => 'localhost',
    'DB_NAME'     => 'upfovlxc_finaldistributorbotplus',      // غيّر هذا
    'DB_USER'     => 'upfovlxc_finaldistributorbotplus',      // غيّر هذا
    'DB_PASS'     => 'cGA?SI]$Sh8#W]j?yZ',  // غيّر هذا
    'DB_CHARSET'  => 'utf8mb4',
    
    // ============================================================
    // إعدادات البوتات
    // ============================================================
    
    // توكن بوت الإدارة (Admin Bot)
    'ADMIN_BOT_TOKEN' => '8380686454:AAGmkclirmB008vjmdEH6oTDq3cRppsKc8M',  // غيّر هذا
    
    // توكن البوت العام (Public Bot)
    'PUBLIC_BOT_TOKEN' => '8439965173:AAGOff6V3yD8sQUp6pBofGOALI48V5sYBnU', // غيّر هذا
    
    // ============================================================
    // معرفات المسؤولين (ADMIN_IDS)
    // ============================================================
    // مصفوفة من Telegram IDs المسموح لهم باستخدام بوت الإدارة
    'ADMIN_IDS' => [
        475567305,  // غيّر هذا - المعرف الأول
        // 987654321, // أضف المزيد إذا لزم
    ],
    
    // ============================================================
    // قناة التفعيل (Activation Channel)
    // ============================================================
    // معرف القناة التي يجب الاشتراك بها قبل استخدام البوت
    // يمكن أن يكون:
    //   - معرف رقمي: -1001234567890
    //   - اسم مستخدم: @channel_username
    'CHANNEL_ID' => '-1003402335792',  // غيّر هذا
    
    // رابط القناة للعرض في الرسائل
    'CHANNEL_LINK' => 'https://t.me/+Bv8Ifqi___I2Y2Fi', // غيّر هذا
    
    // ============================================================
    // إعدادات النظام
    // ============================================================
    
    // رابط الموقع الأساسي (للـ Webhooks)
    'DOMAIN' => 'https://finaldistributorbotplus.upfolo.store', // غيّر هذا
    
    // المنطقة الزمنية
    'TIMEZONE' => 'Asia/Baghdad',
    
    // وضع التصحيح (Debug Mode)
    // true = تسجيل كل الأخطاء والأحداث
    // false = تسجيل الأخطاء الحرجة فقط
    'DEBUG_MODE' => false,
    
    // ============================================================
    // إعدادات الأكواد
    // ============================================================
    
    // بادئة أكواد اشتراك السوبر موزعين
    'SUPERDIST_CODE_PREFIX' => 'SD-',
    
    // بادئة أكواد التفعيل
    'ACTIVATION_CODE_PREFIX' => 'ACT-',
    
    // طول الجزء العشوائي من الكود (بدون البادئة)
    'CODE_RANDOM_LENGTH' => 8,
    
    // ============================================================
    // إعدادات البث (Broadcast)
    // ============================================================
    
    // عدد الرسائل في كل دفعة
    'BROADCAST_BATCH_SIZE' => 25,
    
    // التأخير بين كل رسالة (بالميلي ثانية)
    'BROADCAST_DELAY_MS' => 50,
    
    // التأخير بين كل دفعة (بالثواني)
    'BROADCAST_BATCH_DELAY_SEC' => 1,
    
    // ============================================================
    // إعدادات التقارير
    // ============================================================
    
    // عدد العناصر في كل صفحة (للتقارير المقسمة)
    'REPORT_PAGE_SIZE' => 20,
    
    // الحد الأقصى لطول رسالة تيليجرام
    'TELEGRAM_MAX_MESSAGE_LENGTH' => 4000, // هامش أمان من 4096
    
    // ============================================================
    // إعدادات أكواد التحقق (Verification Codes)
    // ============================================================
    
    // مدة صلاحية كود التحقق بالثواني
    'VERIFICATION_CODE_VALIDITY_SECONDS' => 30,
    
    // ============================================================
    // مسارات الملفات
    // ============================================================
    
    // مسار ملفات السجلات
    'LOG_PATH' => __DIR__ . '/../logs/',
    
    // مسار الملفات المؤقتة (للأكواد المُولَّدة)
    'TEMP_PATH' => __DIR__ . '/../temp/',
];
