# 🚀 دليل النشر السريع

## المتطلبات
- PHP 8.0+
- MySQL 5.7+ / MariaDB 10.3+
- Composer (اختياري)
- SSL Certificate (للـ webhooks)

---

## 1. تهيئة قاعدة البيانات

### تشغيل Migration الجديد:
```bash
mysql -u root -p your_database < sql/migrations/001_vouchers_and_permissions.sql
```

### التحقق من نجاح التهجير:
```sql
-- التحقق من الجداول الجديدة
SHOW TABLES LIKE 'vouchers';
SHOW TABLES LIKE 'broadcast_blacklist';
SHOW TABLES LIKE 'system_check_reports';

-- التحقق من الأعمدة الجديدة في super_distributors
DESCRIBE super_distributors;
-- يجب أن تظهر: can_broadcast, broadcast_allowed_types
```

---

## 2. تحديث الإعدادات

### إضافة للـ `config/env.php`:
```php
<?php
return [
    // ... الإعدادات الموجودة ...
    
    // API Key للواجهات الإدارية
    'admin_api_key' => 'YOUR_SECURE_API_KEY_HERE',
    
    // إعدادات الدفع (اختياري)
    'payment_stripe_webhook_secret' => 'whsec_...',
    'payment_paypal_webhook_secret' => '...',
];
```

---

## 3. إعداد Cron Jobs

### إضافة للـ crontab:
```cron
# تصفير يومي (منتصف الليل)
0 0 * * * php /path/to/project/cron/daily_reset.php >> /path/to/logs/cron.log 2>&1

# تصفير أسبوعي (الأحد منتصف الليل)
0 0 * * 0 php /path/to/project/cron/weekly_reset.php >> /path/to/logs/cron.log 2>&1

# تصفير شهري (أول يوم من الشهر)
0 0 1 * * php /path/to/project/cron/monthly_reset.php >> /path/to/logs/cron.log 2>&1

# تنظيف (يومياً الساعة 3 صباحاً)
0 3 * * * php /path/to/project/cron/cleanup.php >> /path/to/logs/cron.log 2>&1

# انتهاء صلاحية الموزعين (يومياً)
0 1 * * * php /path/to/project/cron/superdist_expiry.php >> /path/to/logs/cron.log 2>&1
```

---

## 4. إعداد Webhooks

### Telegram Bot Webhook:
```bash
# Admin Bot
curl "https://api.telegram.org/bot<ADMIN_TOKEN>/setWebhook?url=https://yourdomain.com/admin_bot.php"

# Public Bot
curl "https://api.telegram.org/bot<PUBLIC_TOKEN>/setWebhook?url=https://yourdomain.com/public_bot.php"
```

### API Endpoint:
```
URL: https://yourdomain.com/api/v1/
```

---

## 5. التحقق من التثبيت

### عبر CLI:
```bash
php cli/system_check.php full
```

### عبر البوت:
```
/run_system_check full
```

### عبر API:
```bash
curl -X POST https://yourdomain.com/api/v1/system/check \
  -H "Content-Type: application/json" \
  -H "X-API-Key: YOUR_API_KEY" \
  -d '{"type": "full"}'
```

---

## 6. الملفات الجديدة

### المكتبات:
- `libs/Voucher.php` - نظام القسائم
- `libs/SystemChecker.php` - فحص النظام
- `libs/BroadcastFilter.php` - فلترة البث

### API:
- `api/v1/index.php` - نقطة دخول API

### CLI:
- `cli/system_check.php` - فحص النظام من سطر الأوامر

### التوثيق:
- `docs/ADMIN_COMMANDS_DOC.md` - توثيق الأوامر
- `docs/openapi.yaml` - مواصفات API

---

## 7. الأوامر الجديدة

### القسائم:
- `/create_voucher` - إنشاء قسيمة
- `/voucher_info` - معلومات قسيمة
- `/list_vouchers` - قائمة القسائم
- `/disable_voucher` - تعطيل قسيمة

### فحص النظام:
- `/run_system_check` - تشغيل الفحص
- `/system_reports` - قائمة التقارير
- `/view_report` - عرض تقرير

### القائمة السوداء:
- `/blacklist_add` - إضافة كلمة
- `/blacklist_remove` - حذف كلمة
- `/blacklist_list` - عرض القائمة

### إعدادات البث:
- `/broadcast_settings` - عرض الإعدادات
- `/set_broadcast_setting` - تعديل إعداد
- `/blocked_broadcasts` - البثات المحظورة
- `/setsuperdistbroadcast` - صلاحيات البث للموزع

### الحسابات:
- `/addaccounts_batch` - إضافة حسابات دفعة

---

## 8. إعدادات البث الافتراضية

| الإعداد | القيمة | الوصف |
|---------|--------|-------|
| chunk_size | 30 | عدد المستلمين في كل دفعة |
| delay_between_chunks_ms | 1000 | التأخير بين الدفعات |
| delay_between_messages_ms | 50 | التأخير بين الرسائل |
| max_retries_on_429 | 3 | إعادة المحاولة عند 429 |
| blacklist_enabled | 1 | تفعيل القائمة السوداء |
| moderation_enabled | 1 | تفعيل المراقبة |

---

## 9. حل المشاكل الشائعة

### "Class 'Voucher' not found":
تأكد من تحميل `libs/bootstrap.php` في بداية الملف.

### "Table 'vouchers' doesn't exist":
شغّل migration:
```bash
mysql -u root -p your_database < sql/migrations/001_vouchers_and_permissions.sql
```

### "Unauthorized" في API:
تأكد من تعيين `admin_api_key` في `config/env.php` وإرساله في header `X-API-Key`.

### فشل فحص Cron:
```bash
# التحقق من crontab
crontab -l

# تشغيل يدوي للاختبار
php cron/daily_reset.php
```

---

## 10. Rollback (التراجع)

### إذا احتجت للتراجع عن التغييرات:
```sql
-- حذف الجداول الجديدة
DROP TABLE IF EXISTS payment_logs;
DROP TABLE IF EXISTS broadcast_errors;
DROP TABLE IF EXISTS broadcast_settings;
DROP TABLE IF EXISTS system_check_reports;
DROP TABLE IF EXISTS blocked_broadcasts;
DROP TABLE IF EXISTS broadcast_blacklist;
DROP TABLE IF EXISTS voucher_codes;
DROP TABLE IF EXISTS voucher_redemptions;
DROP TABLE IF EXISTS vouchers;

-- إزالة الأعمدة الجديدة
ALTER TABLE super_distributors 
DROP COLUMN can_broadcast,
DROP COLUMN broadcast_allowed_types;
```

---

## ✅ قائمة التحقق النهائية

- [ ] تشغيل migration SQL
- [ ] تحديث config/env.php
- [ ] إعداد cron jobs
- [ ] تحديث webhooks
- [ ] تشغيل `/run_system_check full`
- [ ] اختبار `/create_voucher`
- [ ] اختبار API endpoint
- [ ] مراجعة صلاحيات الملفات

---

**تاريخ التحديث:** 2024-12-03  
**الإصدار:** 2.0
