# تقرير التدقيق الشامل للمشروع
## نظام توزيع أكواد التحقق - Telegram Bot
**التاريخ:** 2025-01-15  
**الإصدار:** 1.1

---

## ملخص التنفيذ

### التغييرات المُنجزة في هذه الجلسة:

| # | العنصر | الحالة |
|---|--------|--------|
| 1 | جدول `limits_account` في schema.sql | ✅ مُضاف |
| 2 | `/editaccount` - تعديل الحساب | ✅ مُضاف |
| 3 | `/deleteaccount` - حذف الحساب | ✅ مُضاف |
| 4 | `/setaccountlimits` - حدود الحساب | ✅ مُضاف |
| 5 | `/archivesuperdist` - أرشفة السوبر موزع | ✅ مُضاف |
| 6 | تحديث `Limits.php` لدعم طبقة Account | ✅ مُنجز |
| 7 | تحديث `/help` للإدارة | ✅ مُنجز |
| 8 | تحديث `HELP_SUPERDIST` | ✅ مُنجز |
| 9 | تحديث `HELP_USER` | ✅ مُنجز |
| 10 | تحسين البث (Flood Control) | ✅ مُنجز |

### الإصلاحات أثناء التدقيق:

| # | الملف | المشكلة | الإصلاح |
|---|-------|---------|---------|
| 1 | `SuperDistributorCommands.php` | منطق عرض الحدود المتبقية خاطئ | ✅ تم إصلاحه |
| 2 | `weekly_reset.php` | `activations_week` (خطأ) | ✅ `activations_this_week` |
| 3 | `monthly_reset.php` | `activations_month` (خطأ) | ✅ `activations_this_month` |
| 4 | `daily_reset.php` | `expires_at` (خطأ) | ✅ `access_expires_at` |

---

## هيكل المشروع

```
new projecct/
├── admin_bot.php            # نقطة دخول بوت الإدارة
├── public_bot.php           # نقطة دخول البوت العام
├── config/
│   ├── env.php              # إعدادات البيئة
│   └── limits.php           # الحدود الافتراضية
├── libs/
│   ├── bootstrap.php        # التهيئة والدوال المساعدة
│   ├── Db.php               # طبقة قاعدة البيانات (PDO)
│   ├── Telegram.php         # API تيليجرام
│   ├── Limits.php           # نظام الحدود متعدد الطبقات
│   ├── Replies.php          # نظام الردود
│   ├── Logger.php           # تسجيل الأحداث
│   ├── State.php            # حالات الجلسات
│   └── CodeGenerator.php    # توليد الأكواد
├── src/
│   ├── admin/
│   │   └── Commands.php     # أوامر الإدارة (1430 سطر)
│   └── public/
│       ├── SuperDistributorCommands.php  # أوامر السوبر موزع
│       └── UserCommands.php              # أوامر الزبون
├── cron/
│   ├── daily_reset.php      # تصفير يومي
│   ├── weekly_reset.php     # تصفير أسبوعي
│   ├── monthly_reset.php    # تصفير شهري
│   ├── superdist_expiry.php # انتهاء صلاحيات السوبر
│   └── cleanup.php          # تنظيف عام
├── sql/
│   └── schema.sql           # هيكل قاعدة البيانات (742 سطر)
├── logs/                    # ملفات السجلات
└── temp/                    # ملفات مؤقتة
```

---

## أوامر Admin Bot الكاملة

### أوامر عامة
| الأمر | الوصف |
|-------|-------|
| `/start` | رسالة الترحيب |
| `/help [section]` | المساعدة (sections: accounts, superdists, limits, users, replies, bans, reports, broadcast) |
| `/cancel` | إلغاء العملية الحالية |

### إدارة الحسابات
| الأمر | الوصف |
|-------|-------|
| `/addaccount slug \| name \| secret_key` | إضافة حساب جديد |
| `/editaccount [id\|slug] name=... slug=...` | تعديل حساب |
| `/deleteaccount [id\|slug] confirm` | حذف حساب (لا روابط) |
| `/listaccounts` | قائمة الحسابات |
| `/accountinfo [id\|slug]` | معلومات حساب |
| `/setaccountkey [id] [key]` | تغيير المفتاح السري |
| `/setaccountlimits [id\|slug] daily=X weekly=Y monthly=Z` | حدود الحساب |

### إدارة السوبر موزعين
| الأمر | الوصف |
|-------|-------|
| `/addsuperdist telegram_id \| display_name` | إضافة سوبر موزع |
| `/listsuperdists [status]` | قائمة (status: active, suspended, banned, archived) |
| `/superdistinfo [id]` | معلومات سوبر موزع |
| `/setsuperdistaccounts [sd_id] add [account_ids]` | ربط حسابات |
| `/setsuperdistaccountperiod [sd_id] [acc_id] [days]` | ضبط فترة |
| `/suspendsuperdist [id]` | إيقاف مؤقت |
| `/activatesuperdist [id]` | تفعيل |
| `/archivesuperdist [id] [reason?]` | أرشفة نهائية |
| `/createsuperdistcode [type] [accounts] [days] [uses]` | إنشاء كود اشتراك |
| `/check_code [code]` | فحص كود |
| `/setsuperdistbroadcast [id] [on\|off] [content_type]` | صلاحيات البث |

### إدارة الحدود
| الأمر | الوصف |
|-------|-------|
| `/setgloballimits daily=X weekly=Y monthly=Z` | الحدود العامة (أولوية 4) |
| `/setaccountlimits [slug] daily=X ...` | حدود الحساب (أولوية 3.5) |
| `/setsuperdistlimits [sd_id] daily=X ...` | حدود السوبر موزع (أولوية 3) |
| `/setuserlimits [telegram_id] daily=X ...` | حدود المستخدم (أولوية 2) |
| `/setuseraccountlimits [tg_id] [slug] daily=X ...` | حدود مستخدم+حساب (أولوية 1) |

### إدارة اشتراكات الزبائن
| الأمر | الوصف |
|-------|-------|
| `/setuseraccount_lifetime [telegram_id] [slug]` | تحويل لمدى الحياة |
| `/setuseraccount_period [telegram_id] [slug] [days]` | تحديد فترة مؤقتة |

### إدارة الردود
| الأمر | الوصف |
|-------|-------|
| `/listreplies` | قائمة المفاتيح |
| `/setreply [KEY]` | تعديل رد افتراضي |
| `/setsuperdistreply [sd_id] [KEY]` | رد مخصص لسوبر موزع |
| `/testreply [KEY]` | اختبار رد |

### الحظر
| الأمر | الوصف |
|-------|-------|
| `/ban_user [telegram_id] [reason?]` | حظر مستخدم |
| `/unban_user [telegram_id]` | فك حظر مستخدم |
| `/ban_superdist [id] [reason?]` | حظر سوبر موزع |
| `/unban_superdist [id]` | فك حظر سوبر موزع |

### التقارير
| الأمر | الوصف |
|-------|-------|
| `/system_stats` | إحصائيات النظام |
| `/superdist_stats [id]` | إحصائيات سوبر موزع |
| `/superdist_log [id] [page?]` | سجل أكواد سوبر موزع |
| `/user_info [telegram_id]` | معلومات مستخدم |

### البث
| الأمر | الوصف |
|-------|-------|
| `/broadcast_all` | للجميع |
| `/broadcast_users` | للزبائن فقط |
| `/broadcast_superdists` | للموزعين فقط |
| `/broadcast_superdist_users [sd_id]` | لزبائن موزع معين |

---

## أوامر السوبر موزع (Public Bot)

| الأمر | الوصف |
|-------|-------|
| `/start` | رسالة الترحيب |
| `/help` | المساعدة |
| `/my_accounts` | الحسابات المرتبطة |
| `/mystatus` | حالتي وإحصائياتي |
| `/my_remaining` | الحدود المتبقية |
| `gen_code [slug]` | توليد كود واحد |
| `gen_codes [slug] [count]` | توليد مجموعة |
| `/my_codes [slug] [page]` | عرض أكوادي |
| `/check_code [code]` | فحص كود |
| `/broadcast` | بث لجميع زبائني |
| `/broadcast_my_account [slug]` | بث لزبائن حساب معين |
| `SD-XXXX-XXXX` | تفعيل/تجديد اشتراك |

---

## أوامر الزبون (Public Bot)

| الأمر | الوصف |
|-------|-------|
| `/start` | رسالة الترحيب |
| `/help` | المساعدة |
| `/myaccounts` | حساباتي |
| `/account_info [slug]` | معلومات حساب |
| `get_code [slug]` | طلب كود تحقق |
| `[slug]` | طلب كود تحقق (مباشرة) |
| `ACT-XXXX-XXXX` | تفعيل كود |

---

## نظام الحدود (Limits System)

### ترتيب الأولويات (من الأعلى للأدنى):

```
┌─────────────────────────────────────────────────────────────┐
│ الطبقة 1: user_account (الأعلى)                              │
│ └─ حدود خاصة لمستخدم معين على حساب معين                      │
├─────────────────────────────────────────────────────────────┤
│ الطبقة 2: user                                               │
│ └─ حدود خاصة بمستخدم على جميع حساباته                        │
├─────────────────────────────────────────────────────────────┤
│ الطبقة 3: superdist                                          │
│ └─ حدود لجميع زبائن سوبر موزع معين                           │
├─────────────────────────────────────────────────────────────┤
│ الطبقة 3.5: account (جديد)                                   │
│ └─ حدود افتراضية لحساب معين (جميع المستخدمين)                │
├─────────────────────────────────────────────────────────────┤
│ الطبقة 4: global (الأدنى)                                    │
│ └─ الحدود الافتراضية للنظام                                  │
└─────────────────────────────────────────────────────────────┘
```

### قيم الحدود:
- `NULL` = لا يوجد حد مخصص، استخدم الطبقة الأدنى
- `0` = محظور تماماً
- `> 0` = الحد الفعلي

---

## جداول قاعدة البيانات (18 جدول)

| # | الجدول | الوصف |
|---|--------|-------|
| 1 | `accounts` | الحسابات الرئيسية |
| 2 | `users` | الزبائن |
| 3 | `super_distributors` | السوبر موزعين |
| 4 | `superdist_accounts` | ربط السوبر موزع بالحسابات |
| 5 | `superdist_subscription_codes` | أكواد اشتراك السوبر موزعين (SD-...) |
| 6 | `activation_codes` | أكواد التفعيل (ACT-...) |
| 7 | `user_accounts` | اشتراكات الزبائن |
| 8 | `verification_logs` | سجلات طلب أكواد التحقق |
| 9 | `replies` | الردود الافتراضية |
| 10 | `superdist_replies` | ردود مخصصة لسوبر موزع |
| 11 | `limits_account` | حدود الحساب (جديد) |
| 12 | `limits_global` | الحدود العامة |
| 13 | `limits_superdist` | حدود السوبر موزع |
| 14 | `limits_user` | حدود المستخدم |
| 15 | `limits_user_account` | حدود المستخدم+الحساب |
| 16 | `bans` | سجل الحظر |
| 17 | `broadcast_logs` | سجلات البث |
| 18 | `user_states` | حالات الجلسات |
| 19 | `event_logs` | سجل الأحداث |

---

## ملفات Cron

| الملف | التوقيت | الوظيفة |
|-------|---------|---------|
| `daily_reset.php` | 00:00 يومياً | تصفير العدادات اليومية + الأكواد المنتهية |
| `weekly_reset.php` | 00:00 كل سبت | تصفير العدادات الأسبوعية |
| `monthly_reset.php` | 00:00 أول كل شهر | تصفير العدادات الشهرية |
| `superdist_expiry.php` | 01:00 يومياً | معالجة انتهاء صلاحيات السوبر موزعين |
| `cleanup.php` | 03:00 يومياً | تنظيف الملفات والسجلات القديمة |

### أوامر Cron (cPanel):
```bash
0 0 * * * /usr/bin/php /path/to/cron/daily_reset.php
0 0 * * 6 /usr/bin/php /path/to/cron/weekly_reset.php
0 0 1 * * /usr/bin/php /path/to/cron/monthly_reset.php
0 1 * * * /usr/bin/php /path/to/cron/superdist_expiry.php
0 3 * * * /usr/bin/php /path/to/cron/cleanup.php
```

---

## ملاحظات تقنية مهمة

### 1. البث من بوت الإدارة
البث من بوت الإدارة يستخدم `PUBLIC_BOT_TOKEN` وليس `ADMIN_BOT_TOKEN` لأن المستخدمين تفاعلوا مع البوت العام.

### 2. Flood Control
تم تحسين `Telegram::apiCall()` للتعامل مع خطأ 429:
- استخراج `retry_after` من الاستجابة
- الانتظار للمدة المحددة + 1 ثانية
- الحد الأقصى: 3 محاولات

### 3. الرسائل الطويلة
`Telegram::sendLongMessage()` يقسم الرسائل تلقائياً:
- الحد الآمن: 3800 حرف
- ترقيم الأجزاء: (1/N, 2/N, ...)
- تأخير 100ms بين الأجزاء

### 4. صيغ الأكواد
- أكواد السوبر موزع: `SD-XXXX-XXXX`
- أكواد التفعيل: `ACT-XXXX-XXXX`
- أكواد التحقق: 6 أرقام (TOTP-like)

---

## الحالة النهائية

✅ **المشروع جاهز للإنتاج**

جميع الأوامر متوافقة مع قاعدة البيانات، وتم إصلاح جميع الأخطاء المكتشفة.
